/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpClientFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class HttpClientFactory
implements IHttpClientFactory {
    private final IHttpClientConfiguration configuration;

    public HttpClientFactory(IHttpClientConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public CloseableHttpClient create() {
        switch (this.configuration.getMode()) {
            case CLOSE: {
                return HttpClients.custom().setRedirectStrategy((RedirectStrategy)new RedirectStrategyImplementation()).setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE).setConnectionManager(this.configuration.getManager()).build();
            }
            case KEEP_ALIVE: {
                return HttpClients.custom().setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE).setConnectionManager(this.configuration.getManager()).build();
            }
        }
        return HttpClients.custom().setConnectionManager(this.configuration.getManager()).build();
    }

    @Override
    public IHttpClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    private final class RedirectStrategyImplementation
    extends DefaultRedirectStrategy
    implements RedirectStrategy {
        private RedirectStrategyImplementation() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            Args.notNull((Object)request, (String)"HTTP request");
            Args.notNull((Object)response, (String)"HTTP response");
            if (!super.isRedirected(request, response, context)) {
                int statusCode = response.getStatusLine().getStatusCode();
                String method = request.getRequestLine().getMethod();
                Header locationHeader = response.getFirstHeader("location");
                switch (statusCode) {
                    case 308: {
                        return this.isRedirectable(method) && locationHeader != null;
                    }
                }
                return false;
            }
            return true;
        }
    }
}

