/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IHttpClientFactory;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.Response;
import net.anwiba.commons.http.apache.HttpContextFactory;
import net.anwiba.commons.http.apache.RequestToHttpUriRequestConverter;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.IWatcher;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpRequestExecutor
implements IHttpRequestExecutor {
    private static ILogger logger = Logging.getLogger((String)HttpRequestExecutor.class.getName());
    private CloseableHttpClient client;
    private IHttpClientFactory httpClientFactory;
    private boolean isClosed = false;
    private final RequestToHttpUriRequestConverter requestToHttpUriRequestConverter;
    private final HttpContextFactory httpContextFactory;

    HttpRequestExecutor(HttpConnectionMode httpConnectionMode, IHttpClientFactory httpClientFactory) {
        this.requestToHttpUriRequestConverter = new RequestToHttpUriRequestConverter(httpConnectionMode);
        this.httpContextFactory = new HttpContextFactory();
        this.httpClientFactory = httpClientFactory;
    }

    @Override
    public IResponse execute(ICanceler canceler, IRequest request) throws CanceledException, IOException {
        if (this.isClosed) {
            throw new IOException("executor is closed");
        }
        try {
            HttpUriRequest uriRequest = this.requestToHttpUriRequestConverter.convert(request);
            logger.log(ILevel.DEBUG, () -> MessageFormat.format("request url: <{0}>", uriRequest.getURI()));
            canceler.check();
            this.client = this.client == null ? this.httpClientFactory.create() : this.client;
            HttpResponse httpResponse = this.query(canceler, this.client, request, uriRequest);
            if (HttpConnectionMode.CLOSE.equals((Object)this.httpClientFactory.getClientConfiguration().getMode())) {
                Response response = new Response(canceler, (Closeable)this.client, uriRequest, httpResponse);
                this.client = null;
                logger.log(ILevel.DEBUG, () -> MessageFormat.format("requested code <{1}> url: <{0}>", response.getUri(), response.getStatusCode()));
                return response;
            }
            Response response = new Response(canceler, () -> {}, uriRequest, httpResponse);
            logger.log(ILevel.DEBUG, () -> MessageFormat.format("requested code <{1}> url: <{0}>", response.getUri(), response.getStatusCode()));
            return response;
        }
        catch (IllegalStateException | ConversionException exception) {
            logger.log(ILevel.ALL, exception.getMessage(), exception);
            throw new IOException(exception.getMessage());
        }
    }

    private HttpResponse query(ICanceler canceler, CloseableHttpClient httpClient, IRequest request, HttpUriRequest method) throws IOException, ClientProtocolException {
        try (IWatcher watcher = (IWatcher)canceler.watcherFactory().create(() -> method.abort());){
            if (request.getAuthentication() != null) {
                CloseableHttpResponse closeableHttpResponse = httpClient.execute(method, this.httpContextFactory.create(request));
                return closeableHttpResponse;
            }
            CloseableHttpResponse closeableHttpResponse = httpClient.execute(method);
            return closeableHttpResponse;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            if (this.client == null) {
                return;
            }
            this.client.close();
        }
        finally {
            this.isClosed = true;
            this.httpClientFactory = null;
            this.client = null;
        }
    }
}

