/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.HttpRequestExecutorFactory;
import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpRequestExecutorFactory;
import net.anwiba.commons.http.IHttpRequestExecutorFactoryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpRequestExecutorFactoryBuilder
implements IHttpRequestExecutorFactoryBuilder {
    private IHttpClientConfiguration configuration = new IHttpClientConfiguration(){

        @Override
        public HttpConnectionMode getMode() {
            return HttpConnectionMode.CLOSE;
        }

        @Override
        public HttpClientConnectionManager getManager() {
            return new BasicHttpClientConnectionManager();
        }
    };

    @Override
    public IHttpRequestExecutorFactoryBuilder usePoolingConnection() {
        this.configuration = new IHttpClientConfiguration(){

            @Override
            public HttpConnectionMode getMode() {
                return HttpConnectionMode.KEEP_ALIVE;
            }

            @Override
            public HttpClientConnectionManager getManager() {
                return new PoolingHttpClientConnectionManager();
            }
        };
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder useAlwaysTheSameConnection() {
        this.configuration = new IHttpClientConfiguration(){

            @Override
            public HttpConnectionMode getMode() {
                return HttpConnectionMode.KEEP_ALIVE;
            }

            @Override
            public HttpClientConnectionManager getManager() {
                return new BasicHttpClientConnectionManager();
            }
        };
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder useAlwaysANewConnection() {
        this.configuration = new IHttpClientConfiguration(){

            @Override
            public HttpConnectionMode getMode() {
                return HttpConnectionMode.CLOSE;
            }

            @Override
            public HttpClientConnectionManager getManager() {
                return new BasicHttpClientConnectionManager();
            }
        };
        return this;
    }

    @Override
    public IHttpRequestExecutorFactory build() {
        return new HttpRequestExecutorFactory(this.configuration);
    }
}

