/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import net.anwiba.commons.lang.functional.IClosure;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;

public class InputStreamEntity
extends AbstractHttpEntity {
    private final IClosure<InputStream, IOException> content;
    private final long length;

    public InputStreamEntity(IClosure<InputStream, IOException> contentClosure, long length, ContentType contentType) {
        this.content = Objects.requireNonNull(contentClosure, "no content");
        this.length = length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException {
        return (InputStream)this.content.execute();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        block10: {
            Objects.requireNonNull(outstream, "no content");
            try (InputStream instream = (InputStream)this.content.execute();){
                int size;
                byte[] buffer = new byte[4096];
                if (this.length < 0L) {
                    int size2;
                    while ((size2 = instream.read(buffer)) != -1) {
                        outstream.write(buffer, 0, size2);
                    }
                    break block10;
                }
                for (long remaining = this.length; remaining > 0L; remaining -= (long)size) {
                    size = instream.read(buffer, 0, (int)Math.min(4096L, remaining));
                    if (size == -1) {
                        break;
                    }
                    outstream.write(buffer, 0, size);
                }
            }
        }
    }

    public boolean isStreaming() {
        return true;
    }
}

