/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.apache;

import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.apache.InputStreamEntity;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.io.url.UrlBuilder;
import net.anwiba.commons.utilities.io.url.parser.UrlParser;
import net.anwiba.commons.utilities.parameter.IParameter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;

public final class RequestToHttpUriRequestConverter {
    private final HttpConnectionMode httpConnectionMode;

    public RequestToHttpUriRequestConverter(HttpConnectionMode httpConnectionMode) {
        this.httpConnectionMode = httpConnectionMode;
    }

    public HttpUriRequest convert(IRequest request) throws ConversionException {
        try {
            UrlBuilder urlBuilder = new UrlBuilder(new UrlParser().parse(request.getUriString()));
            request.getParameters().forEach(arg_0 -> ((UrlBuilder)urlBuilder).addQueryParameter(arg_0));
            IUrl url = urlBuilder.build();
            switch (request.getMethodType()) {
                case POST: {
                    RequestBuilder requestBuilder = RequestBuilder.post((String)url.encoded());
                    this.addToHeader(request.getProperties().parameters(), requestBuilder);
                    Optional.ofNullable(request.getUserAgent()).ifPresent(value -> requestBuilder.addHeader("User-Agent", value));
                    HttpEntity entity = this.createEntity(request);
                    requestBuilder.setEntity(entity);
                    return requestBuilder.build();
                }
                case GET: {
                    RequestBuilder requestBuilder = RequestBuilder.get((String)url.encoded());
                    this.addToHeader(request.getProperties().parameters(), requestBuilder);
                    Optional.ofNullable(request.getUserAgent()).ifPresent(value -> requestBuilder.addHeader("User-Agent", value));
                    return requestBuilder.build();
                }
            }
        }
        catch (IllegalArgumentException | CreationException exception) {
            throw new ConversionException("Couldn't convert reqeut to appache http request.", exception);
        }
        throw new UnreachableCodeReachedException();
    }

    private void addToQuery(IRequest request, RequestBuilder requestBuilder) {
        for (IParameter parameter : request.getParameters().parameters()) {
            requestBuilder.addParameter(parameter.getName(), parameter.getValue());
        }
    }

    private void addToHeader(Iterable<IParameter> parameters, RequestBuilder requestBuilder) {
        for (IParameter parameter : parameters) {
            if (Objects.equals("Connection", parameter.getName()) && HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode)) continue;
            requestBuilder.addHeader(parameter.getName(), parameter.getValue());
        }
        if (HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode)) {
            requestBuilder.addHeader("Connection", "Close");
        }
    }

    private HttpEntity createEntity(IRequest request) {
        String encoding = request.getEncoding();
        Charset charset = encoding == null ? null : Charset.forName(encoding);
        ContentType contentType = ContentType.create((String)request.getMimeType(), (Charset)charset);
        return new InputStreamEntity(request.getContent(), request.getContentLength(), contentType);
    }
}

