/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import net.anwiba.commons.http.ExceptionProducer;
import net.anwiba.commons.http.HttpRequestException;
import net.anwiba.commons.http.HttpServerException;
import net.anwiba.commons.http.IApplicableHttpResponseExceptionFactory;
import net.anwiba.commons.http.IApplicableResultProducer;
import net.anwiba.commons.http.IConvertingHttpRequestExecutor;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.IResultProducer;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.io.NoneClosingInputStream;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;

public class ConvertingHttpRequestExecutor
implements IConvertingHttpRequestExecutor {
    private final IHttpRequestExecutor httpRequestExecutor;

    public ConvertingHttpRequestExecutor(IHttpRequestExecutor httpRequestExecutor) {
        this.httpRequestExecutor = httpRequestExecutor;
    }

    @Override
    public <T> T execute(ICanceler cancelable, IRequest request, IApplicableResultProducer<T> resultProducer, IApplicableHttpResponseExceptionFactory ... exceptionFactories) throws CanceledException, HttpServerException, HttpRequestException, IOException {
        return this.execute(cancelable, request, resultProducer, (IResultProducer<IOException>)new ExceptionProducer(exceptionFactories));
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T execute(ICanceler cancelable, IRequest request, IApplicableResultProducer<T> resultProducer, IResultProducer<IOException> errorProducer) throws CanceledException, HttpServerException, HttpRequestException, IOException {
        try {
            IResponse response = this.httpRequestExecutor.execute(cancelable, request);
            int statusCode = response.getStatusCode();
            String statusText = response.getStatusText();
            long contentLength = response.getContentLength();
            if (contentLength == 0L) {
                throw new HttpServerException("Http request faild, empty response", response.getUri(), statusCode, statusText);
            }
            String contentType = response.getContentType();
            if (resultProducer.isApplicable(statusCode, contentType)) {
                InputStream stream = response.getInputStream();
                BufferedInputStream inputStream = new BufferedInputStream((InputStream)new NoneClosingInputStream(stream));
                ((InputStream)inputStream).mark(IoUtilities.maximumLimitOfBytes((long)contentLength));
                Object t = resultProducer.execute(cancelable, response.getUri(), statusCode, statusText, contentType, response.getContentEncoding(), inputStream);
                return t;
                {
                    catch (IOException exception) {
                        ((InputStream)inputStream).reset();
                        throw new HttpRequestException(exception.getMessage(), response.getUri(), statusCode, statusText, IoUtilities.toByteArray((InputStream)inputStream), contentType, response.getContentEncoding(), exception);
                    }
                    finally {
                        ((InputStream)inputStream).close();
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            InputStream inputStream = response.getInputStream();
            try {
                throw errorProducer.execute(cancelable, response.getUri(), statusCode, statusText, contentType, response.getContentEncoding(), inputStream);
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (InterruptedIOException exception) {
            CanceledException CanceledException2 = new CanceledException();
            CanceledException2.initCause((Throwable)exception);
            throw CanceledException2;
        }
    }

    @Override
    public void close() throws IOException {
        this.httpRequestExecutor.close();
    }
}

