/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpClientFactory;
import net.anwiba.commons.http.IHttpProxyConfiguration;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class HttpClientFactory
implements IHttpClientFactory {
    private final IHttpClientConfiguration configuration;

    public HttpClientFactory(IHttpClientConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public CloseableHttpClient create() {
        HttpClientBuilder builder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new RedirectStrategyImplementation()).setConnectionManager(this.configuration.getManager());
        this.configuration.getProxyConfiguration().consume(c -> this.addProxies(builder, (IHttpProxyConfiguration)c));
        switch (this.configuration.getMode()) {
            case CLOSE: {
                return builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                    public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
                        return TimeValue.ZERO_MILLISECONDS;
                    }
                }).setConnectionReuseStrategy(new ConnectionReuseStrategy(){

                    public boolean keepAlive(HttpRequest request, HttpResponse response, HttpContext context) {
                        return false;
                    }
                }).build();
            }
        }
        return builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE).build();
    }

    private void addProxies(HttpClientBuilder builder, IHttpProxyConfiguration configuration) {
        builder.setProxy(new HttpHost(configuration.getScheme(), configuration.getHost(), configuration.getPort()));
    }

    @Override
    public IHttpClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    private final class RedirectStrategyImplementation
    extends DefaultRedirectStrategy
    implements RedirectStrategy {
        private RedirectStrategyImplementation() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            Args.notNull((Object)request, (String)"HTTP request");
            Args.notNull((Object)response, (String)"HTTP response");
            return super.isRedirected(request, response, context) || this.isRedirectedHttp308(request, response);
        }

        private boolean isRedirectedHttp308(HttpRequest request, HttpResponse response) {
            int statusCode = response.getCode();
            return statusCode == 308;
        }
    }
}

