/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.reference.utilities.IoUtilities;

public class HttpRequestException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final int statusCode;
    private final String statusText;
    private final byte[] content;
    private final String contentType;
    private final String contentEncoding;
    private String url;

    public HttpRequestException(String message, String url, int statusCode, String statusText, byte[] content, String contentType, String contentEncoding) {
        super(message);
        this.url = url;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.content = content;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    public HttpRequestException(String message, String url, int statusCode, String statusText, byte[] content, String contentType, String contentEncoding, Throwable throwable) {
        super(message, throwable);
        this.url = url;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.content = content;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getContentLength() {
        return this.content.length;
    }

    public String getContentAsString() {
        try {
            return new String(this.content, this.contentEncoding);
        }
        catch (IOException exception) {
            return new String(this.content);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public static HttpRequestException create(String message, IResponse response, byte[] body) {
        return new HttpRequestException(message, response.getUri(), response.getStatusCode(), response.getStatusText(), body, response.getContentType(), response.getContentEncoding());
    }

    public static HttpRequestException create(String message, IResponse response) throws IOException {
        try (InputStream inputStream = response.getInputStream();){
            HttpRequestException httpRequestException = new HttpRequestException(message, response.getUri(), response.getStatusCode(), response.getStatusText(), IoUtilities.toByteArray((InputStream)inputStream), response.getContentType(), response.getContentEncoding());
            return httpRequestException;
        }
    }
}

