/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.HttpRequestExecutorFactory;
import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpProxyConfiguration;
import net.anwiba.commons.http.IHttpRequestExecutorFactory;
import net.anwiba.commons.http.IHttpRequestExecutorFactoryBuilder;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;

public class HttpRequestExecutorFactoryBuilder
implements IHttpRequestExecutorFactoryBuilder {
    private IHttpClientConfiguration configuration = new IHttpClientConfiguration(){

        @Override
        public HttpConnectionMode getMode() {
            return HttpConnectionMode.CLOSE;
        }

        @Override
        public HttpClientConnectionManager getManager() {
            return new BasicHttpClientConnectionManager();
        }
    };
    final PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
    private IHttpProxyConfiguration proxyConfiguration = null;

    @Override
    public IHttpRequestExecutorFactoryBuilder setProxy(final String scheme, final String hostname, final int port) {
        this.proxyConfiguration = new IHttpProxyConfiguration(){

            @Override
            public int getPort() {
                return port;
            }

            @Override
            public String getHost() {
                return hostname;
            }

            @Override
            public String getScheme() {
                return scheme;
            }
        };
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder usePoolingConnection() {
        this.configuration = new IHttpClientConfiguration(){

            @Override
            public HttpConnectionMode getMode() {
                return HttpConnectionMode.KEEP_ALIVE;
            }

            @Override
            public HttpClientConnectionManager getManager() {
                return HttpRequestExecutorFactoryBuilder.this.poolingHttpClientConnectionManager;
            }
        };
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder useAlwaysTheSameConnection() {
        this.configuration = new IHttpClientConfiguration(){
            final BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager();

            @Override
            public HttpConnectionMode getMode() {
                return HttpConnectionMode.KEEP_ALIVE;
            }

            @Override
            public HttpClientConnectionManager getManager() {
                return this.basicHttpClientConnectionManager;
            }
        };
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder useAlwaysANewConnection() {
        this.configuration = new IHttpClientConfiguration(){

            @Override
            public HttpConnectionMode getMode() {
                return HttpConnectionMode.CLOSE;
            }

            @Override
            public HttpClientConnectionManager getManager() {
                return new BasicHttpClientConnectionManager();
            }
        };
        return this;
    }

    @Override
    public IHttpRequestExecutorFactory build() {
        return new HttpRequestExecutorFactory(new IHttpClientConfiguration(){

            @Override
            public HttpConnectionMode getMode() {
                return HttpRequestExecutorFactoryBuilder.this.configuration.getMode();
            }

            @Override
            public HttpClientConnectionManager getManager() {
                return HttpRequestExecutorFactoryBuilder.this.configuration.getManager();
            }

            @Override
            public IOptional<IHttpProxyConfiguration, RuntimeException> getProxyConfiguration() {
                return Optional.of((Object)HttpRequestExecutorFactoryBuilder.this.proxyConfiguration);
            }
        });
    }
}

