/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.anwiba.commons.cache.resource.ILifeTime;
import net.anwiba.commons.http.Authentication;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.HttpMethodType;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.Request;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IClosure;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.Parameter;
import net.anwiba.commons.lang.parameter.ParametersBuilder;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.io.url.parser.UrlParser;
import net.anwiba.commons.utilities.string.StringUtilities;

public class RequestBuilder {
    private HttpMethodType httpMethodType = HttpMethodType.GET;
    private HttpConnectionMode httpConnectionMode = null;
    private final String urlString;
    private final List<IParameter> queryParameters = new ArrayList<IParameter>();
    private final List<IParameter> headerParameters = new ArrayList<IParameter>();
    private IClosure<InputStream, IOException> inputStreamClosure;
    private long contentLenght;
    private String encoding;
    private String mimeType;
    private String userAgent;
    private IAuthentication authentication;
    private ILifeTime cacheTime;

    public static RequestBuilder get(String urlString) {
        return new RequestBuilder(urlString).get();
    }

    public static RequestBuilder post(String urlString) {
        return new RequestBuilder(urlString).post();
    }

    private RequestBuilder(String urlString) {
        this.urlString = urlString;
    }

    private RequestBuilder post() {
        this.httpMethodType = HttpMethodType.POST;
        return this;
    }

    private RequestBuilder get() {
        this.httpMethodType = HttpMethodType.GET;
        return this;
    }

    public RequestBuilder authentication(String userName, String password) {
        if (StringUtilities.isNullOrTrimmedEmpty((String)userName) || StringUtilities.isNullOrTrimmedEmpty((String)password)) {
            return this;
        }
        this.authentication = new Authentication(userName, password);
        return this;
    }

    public RequestBuilder query(String key, String value) {
        this.queryParameters.add(Parameter.of((String)key, (String)value));
        return this;
    }

    public RequestBuilder query(IParameter parameter) {
        this.queryParameters.add(parameter);
        return this;
    }

    public RequestBuilder header(String key, String value) {
        this.headerParameters.add(Parameter.of((String)key, (String)value));
        return this;
    }

    public RequestBuilder header(IParameter parameter) {
        this.headerParameters.add(parameter);
        return this;
    }

    public RequestBuilder connectionClose() {
        this.httpConnectionMode = HttpConnectionMode.CLOSE;
        return this;
    }

    public RequestBuilder connectionKeepAlive() {
        this.httpConnectionMode = HttpConnectionMode.KEEP_ALIVE;
        return this;
    }

    public RequestBuilder content(byte[] content) {
        this.contentLenght = content.length;
        this.inputStreamClosure = () -> new ByteArrayInputStream(content);
        return this;
    }

    public RequestBuilder contentEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public RequestBuilder mimeType(String mimeTye) {
        this.mimeType = mimeTye;
        return this;
    }

    public RequestBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public RequestBuilder cacheTime(ILifeTime cacheTime) {
        this.cacheTime = cacheTime;
        return this;
    }

    public IRequest build() throws CreationException {
        IUrl uri = new UrlParser().parse(this.urlString);
        int port = uri.getPort();
        String host = uri.getHostname();
        Optional.of((Object)((Object)this.httpConnectionMode)).consume(m -> this.headerParameters.add(Parameter.of((String)"Connection", (String)(HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode) ? "close" : "keep-alive"))));
        return new Request(this.httpMethodType, uri.getScheme().stream().collect(Collectors.joining(":")), host, port, this.authentication, this.urlString, new ParametersBuilder().add(this.queryParameters).build(), new ParametersBuilder().add(this.headerParameters).build(), this.userAgent, this.inputStreamClosure, this.contentLenght, this.encoding, this.mimeType, this.cacheTime);
    }

    public RequestBuilder query(Iterable<IParameter> parameters) {
        parameters.forEach(p -> this.query((IParameter)p));
        return this;
    }
}

