/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParameterList;
import jakarta.activation.MimeTypeParseException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.anwiba.commons.http.CancelableInputStream;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.StatusCodes;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.utilities.string.StringUtilities;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.net.URIAuthority;

public final class Response
implements IResponse {
    private final HttpResponse response;
    private final ICanceler cancelable;
    private final HttpUriRequest request;
    private final Closeable client;
    private byte[] body;

    public Response(ICanceler cancelable, Closeable client, HttpUriRequest request, HttpResponse response) {
        this.cancelable = cancelable;
        this.client = client;
        this.request = request;
        this.response = response;
    }

    @Override
    public IOptional<List<String>, RuntimeException> cacheControl() {
        Object[] headers = this.response.getHeaders("Cache-control");
        return headers == null || headers.length == 0 ? Optional.empty() : Optional.of((Object)Streams.of((Object[])headers).convert(h -> h.getValue()).asList());
    }

    @Override
    public IOptional<String, RuntimeException> expires() {
        Header header = this.response.getFirstHeader("Expires");
        return header == null ? Optional.empty() : Optional.of((Object)header.getValue());
    }

    @Override
    public IOptional<String, RuntimeException> pragma() {
        Header header = this.response.getFirstHeader("Pragma");
        return header == null ? Optional.empty() : Optional.of((Object)header.getValue());
    }

    @Override
    public String getUri() {
        String path;
        StringBuilder builder = new StringBuilder();
        URIAuthority authority = this.request.getAuthority();
        if (authority != null) {
            String scheme = this.request.getScheme();
            builder.append(scheme != null ? scheme : URIScheme.HTTP.id).append("://");
            builder.append(authority.getHostName());
            if (authority.getPort() >= 0) {
                builder.append(":").append(authority.getPort());
            }
        }
        if ((path = this.request.getPath()) == null) {
            builder.append("/");
        } else {
            if (builder.length() > 0 && !path.startsWith("/")) {
                builder.append("/");
            }
            builder.append(path);
        }
        return builder.toString();
    }

    @Override
    public String getBody() throws IOException {
        if (this.body != null) {
            return new String(this.body, this.getContentEncoding());
        }
        try (InputStream inputStream = this.getInputStream();){
            this.body = IoUtilities.toByteArray((InputStream)inputStream);
            String string = new String(this.body, this.getContentEncoding());
            return string;
        }
    }

    @Override
    public int getStatusCode() {
        return (Integer)Optional.of((Object)this.response).convert(r -> r.getCode()).getOr(() -> 404);
    }

    @Override
    public String getStatusText() {
        return (String)Optional.of((Object)this.response).convert(r -> r.getReasonPhrase()).getOr(() -> StatusCodes.getPhrase(this.getStatusCode()));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.body != null) {
            return new CancelableInputStream(this.cancelable, new ByteArrayInputStream(this.body));
        }
        return new CancelableInputStream(this.cancelable, (InputStream)Optional.of(IOException.class, (Object)this.response).instanceOf(HttpEntityContainer.class).convert(r -> r.getEntity()).convert(e -> e.getContent()).getOrThrow(() -> new IOException()));
    }

    @Override
    public long getContentLength() {
        return (Long)Optional.of((Object)this.response).instanceOf(HttpEntityContainer.class).convert(r -> r.getEntity()).convert(e -> e.getContentLength()).getOr(() -> 0L);
    }

    @Override
    public String getContentType() {
        return (String)Optional.of((Object)this.response).instanceOf(HttpEntityContainer.class).convert(r -> r.getEntity()).convert(e -> e.getContentType()).get();
    }

    @Override
    public String getContentEncoding() {
        return (String)Optional.of((Object)this.response).instanceOf(HttpEntityContainer.class).convert(r -> r.getEntity()).convert(e -> e.getContentEncoding()).getOr(() -> this.getContentEncodingfromContentType());
    }

    private String getContentEncodingfromContentType() {
        try {
            String contentType = this.getContentType();
            if (StringUtilities.isNullOrTrimmedEmpty((String)contentType)) {
                return "UTF-8";
            }
            MimeType mimeType = new MimeType(contentType);
            MimeTypeParameterList parameters = mimeType.getParameters();
            String charset = parameters.get("charset");
            if (StringUtilities.isNullOrTrimmedEmpty((String)charset)) {
                return "UTF-8";
            }
            return charset;
        }
        catch (MimeTypeParseException exception) {
            return "UTF-8";
        }
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        if (this.response instanceof CloseableHttpResponse) {
            exception = IoUtilities.close(() -> ((CloseableHttpResponse)this.response).close(), exception);
        }
        exception = IoUtilities.close((Closeable)this.client, exception);
        IoUtilities.toss((IOException)exception);
    }

    @Override
    public void abort() {
        this.request.abort();
    }
}

