/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.apache;

import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.lang.optional.Optional;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

public final class HttpContextFactory {
    public HttpContext create(IRequest request) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        IAuthentication authentication = request.getAuthentication();
        char[] password = (char[])Optional.of((Object)authentication.getPassword()).convert(p -> p.toCharArray()).get();
        HttpHost host = new HttpHost(request.getUriString().toLowerCase().startsWith("https:") ? "https" : "http", request.getHost(), request.getPort());
        credentialsProvider.setCredentials(new AuthScope(host), (Credentials)new UsernamePasswordCredentials(authentication.getUsername(), password));
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(host, (AuthScheme)new BasicScheme());
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }
}

