/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.apache;

import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.apache.InputStreamEntity;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.io.url.UrlBuilder;
import net.anwiba.commons.utilities.io.url.parser.UrlParser;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;

public final class RequestToHttpUriRequestConverter {
    private final HttpConnectionMode httpConnectionMode;

    public RequestToHttpUriRequestConverter(HttpConnectionMode httpConnectionMode) {
        this.httpConnectionMode = httpConnectionMode;
    }

    public HttpUriRequest convert(IRequest request) throws ConversionException {
        try {
            UrlBuilder urlBuilder = new UrlBuilder(new UrlParser().parse(request.getUriString()));
            request.getParameters().forEach(arg_0 -> ((UrlBuilder)urlBuilder).addQueryParameter(arg_0));
            IUrl url = urlBuilder.build();
            switch (request.getMethodType()) {
                case POST: {
                    HttpPost post = new HttpPost(url.encoded());
                    this.addToHeader(request.getProperties().parameters(), (HttpMessage)post);
                    Optional.ofNullable(request.getUserAgent()).ifPresent(value -> post.addHeader("User-Agent", value));
                    HttpEntity entity = this.createEntity(request);
                    post.setEntity(entity);
                    return post;
                }
                case GET: {
                    HttpGet get = new HttpGet(url.encoded());
                    this.addToHeader(request.getProperties().parameters(), (HttpMessage)get);
                    Optional.ofNullable(request.getUserAgent()).ifPresent(value -> get.addHeader("User-Agent", value));
                    return get;
                }
            }
        }
        catch (IllegalArgumentException | CreationException exception) {
            throw new ConversionException("Couldn't convert reqeut to appache http request.", exception);
        }
        throw new UnreachableCodeReachedException();
    }

    private void addToHeader(Iterable<IParameter> parameters, HttpMessage requestBuilder) {
        for (IParameter parameter : parameters) {
            if (Objects.equals("Connection", parameter.getName()) && HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode)) continue;
            requestBuilder.addHeader(parameter.getName(), (Object)parameter.getValue());
        }
        if (HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode)) {
            requestBuilder.addHeader("Connection", (Object)"close");
        }
    }

    private HttpEntity createEntity(IRequest request) {
        String encoding = request.getEncoding();
        Charset charset = encoding == null ? null : Charset.forName(encoding);
        ContentType contentType = ContentType.create((String)request.getMimeType(), (Charset)charset);
        return new InputStreamEntity(request.getContent(), request.getContentLength(), contentType, encoding);
    }
}

