/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.util.Objects;
import net.anwiba.commons.http.IAuthentication;

public final class Authentication
implements IAuthentication {
    private final String userName;
    private final String password;
    private final Mode mode;

    public Authentication(String userName, String password) {
        this(userName, password, Mode.LAZY);
    }

    public Authentication(String userName, String password, Mode mode) {
        this.userName = userName;
        this.password = password;
        this.mode = mode;
    }

    @Override
    public String getUsername() {
        return this.userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isLazy() {
        return Objects.equals((Object)Mode.LAZY, (Object)this.mode);
    }

    @Override
    public boolean isPreemptive() {
        return Objects.equals((Object)Mode.PREEMPTIVE, (Object)this.mode);
    }

    @Override
    public boolean isForces() {
        return Objects.equals((Object)Mode.FORCED, (Object)this.mode);
    }

    public String toString() {
        return this.userName + ";" + this.password;
    }

    public static enum Mode {
        LAZY,
        PREEMPTIVE,
        FORCED;

    }
}

