/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import net.anwiba.commons.cache.resource.CachingRule;
import net.anwiba.commons.cache.resource.ILifeTime;
import net.anwiba.commons.cache.resource.IResourceCache;
import net.anwiba.commons.http.HttpRequestCacheKey;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.url.IUrl;
import net.anwiba.commons.reference.url.builder.UrlBuilder;
import net.anwiba.commons.reference.url.parser.UrlParser;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;

public class CachingHttpRequestExecutor
implements IHttpRequestExecutor {
    private static ILogger logger = Logging.getLogger(CachingHttpRequestExecutor.class);
    private final IHttpRequestExecutor httpRequestExecutor;
    private final IResourceCache cache;
    private final IResourceReferenceHandler resourceReferenceHandler;
    private final Map<HttpRequestCacheKey, Future<StaticResponse>> registeredRequests;

    public CachingHttpRequestExecutor(IResourceCache cache, Map<HttpRequestCacheKey, Future<StaticResponse>> registeredRequests, IResourceReferenceHandler resourceReferenceHandler, IHttpRequestExecutor httpRequestExecutor) {
        this.cache = cache;
        this.registeredRequests = registeredRequests;
        this.resourceReferenceHandler = resourceReferenceHandler;
        this.httpRequestExecutor = httpRequestExecutor;
    }

    @Override
    public IResponse execute(ICanceler cancelable, IRequest request) throws CanceledException, IOException {
        String url = this.createUrl(request.getUriString(), request.getParameters());
        IOptional<HttpRequestCacheKey, RuntimeException> key = HttpRequestCacheKey.of(request);
        IOptional<IResourceReference, RuntimeException> optional = this.get(key);
        if (optional.isEmpty()) {
            try {
                Callable<StaticResponse> callable = () -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                };
                FutureTask<StaticResponse> future = new FutureTask<StaticResponse>(callable);
                this.registeredRequests.put((HttpRequestCacheKey)key.get(), future);
                future.run();
                IResponse iResponse = future.get();
                return iResponse;
            }
            catch (InterruptedException | CancellationException exception) {
                throw new CanceledException(exception.getMessage(), (Throwable)exception);
            }
            catch (ExecutionException exception) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof CancellationException) {
                    CancellationException ce = (CancellationException)throwable;
                    throw new CanceledException(ce.getMessage(), (Throwable)ce);
                }
                throwable = exception.getCause();
                if (throwable instanceof IOException) {
                    IOException ioe = (IOException)throwable;
                    throw ioe;
                }
                throw new IOException(exception.getMessage(), exception);
            }
            finally {
                Future<StaticResponse> future = this.registeredRequests.remove(key.get());
                if (future != null && !future.isDone()) {
                    future.cancel(true);
                }
            }
        }
        logger.debug("got cached response " + url);
        return this.create(url, (IResourceReference)optional.get(), (IBlock<RuntimeException>)((IBlock)() -> {}), 200, "OK");
    }

    private synchronized IOptional<IResourceReference, RuntimeException> get(IOptional<HttpRequestCacheKey, RuntimeException> key) {
        return (IOptional)key.convert(arg_0 -> ((IResourceCache)this.cache).getResourceReference(arg_0)).getOr(() -> key.convert(this.registeredRequests::get).convert(f -> {
            try {
                IResourceReference resourceReference = ((StaticResponse)f.get()).getResourceReference();
                logger.debug("got reponse from registered future: " + ((HttpRequestCacheKey)key.get()).getUrl());
                return resourceReference;
            }
            catch (InterruptedException | ExecutionException exception) {
                return null;
            }
        }));
    }

    private IResourceReference reference(IResponse response) throws IOException {
        if (response.getContentLength() == 0L) {
            return new ResourceReferenceFactory().create(new byte[0], response.getContentType(), response.getContentEncoding());
        }
        try (InputStream inputStream = response.getInputStream();){
            IResourceReference iResourceReference = new ResourceReferenceFactory().create(IoUtilities.toByteArray((InputStream)inputStream), response.getContentType(), response.getContentEncoding());
            return iResourceReference;
        }
    }

    private StaticResponse create(String url, IResourceReference resourceReference, IBlock<RuntimeException> abortBlock, int statusCode, String statusTest) {
        return new StaticResponse(this.resourceReferenceHandler, abortBlock, url, resourceReference, statusCode, statusTest);
    }

    private String createUrl(String uriString, IParameters parameters) {
        try {
            IUrl url = new UrlParser().parse(uriString);
            UrlBuilder builder = new UrlBuilder(url);
            parameters.forEach(p -> builder.addQueryParameter(p));
            return builder.build().toString();
        }
        catch (CreationException e) {
            return uriString;
        }
    }

    @Override
    public void close() throws IOException {
        this.httpRequestExecutor.close();
    }

    private static /* synthetic */ void lambda$execute$4() throws RuntimeException {
    }

    private /* synthetic */ IResourceReference lambda$execute$3(IOptional key, byte[] byteArray, IResponse response) throws RuntimeException {
        return this.cache.put(key.get(), byteArray, response.getContentType(), response.getContentEncoding());
    }

    private /* synthetic */ IResourceReference lambda$execute$2(IOptional key, byte[] byteArray, IResponse response, ILifeTime cacheTime) throws RuntimeException {
        return this.cache.put(CachingRule.builder().preferdLifeTime(cacheTime).minimumLifeTime(cacheTime).maximumLifeTime(cacheTime).build(), key.get(), byteArray, response.getContentType(), response.getContentEncoding());
    }

    private static /* synthetic */ void lambda$execute$1() throws RuntimeException {
    }

    private static /* synthetic */ void lambda$execute$0(IResponse response) {
        response.abort();
    }

    public static final class StaticResponse
    implements IResponse {
        private final int statusCode;
        private final IResourceReference resourceReference;
        private final String url;
        private final String statusTest;
        private final IResourceReferenceHandler resourceReferenceHandler;
        private final IBlock<RuntimeException> abortBlock;

        public StaticResponse(IResourceReferenceHandler resourceReferenceHandler, IBlock<RuntimeException> abortBlock, String url, IResourceReference resourceReference, int statusCode, String statusTest) {
            this.resourceReferenceHandler = resourceReferenceHandler;
            this.abortBlock = abortBlock;
            this.statusCode = statusCode;
            this.resourceReference = resourceReference;
            this.url = url;
            this.statusTest = statusTest;
        }

        public IResourceReference getResourceReference() {
            return this.resourceReference;
        }

        @Override
        public String getUri() {
            return this.url;
        }

        @Override
        public String getStatusText() {
            return this.statusTest;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.resourceReferenceHandler.openInputStream(this.resourceReference);
        }

        @Override
        public String getContentType() {
            return this.resourceReferenceHandler.getContentType(this.resourceReference);
        }

        @Override
        public long getContentLength() {
            return this.resourceReferenceHandler.getContentLength(this.resourceReference);
        }

        @Override
        public String getContentEncoding() {
            return "UTF-8";
        }

        @Override
        public String getBody() throws IOException {
            return this.resourceReferenceHandler.toString(this.resourceReference);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void abort() {
            this.abortBlock.execute();
        }
    }
}

