/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.http.HttpResponseException;
import net.anwiba.commons.http.IApplicableHttpResponseExceptionFactory;
import net.anwiba.commons.http.IResultProducer;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;

public final class ExceptionProducer
implements IResultProducer<IOException> {
    private final IApplicableHttpResponseExceptionFactory[] exceptionFactories;

    public ExceptionProducer(IApplicableHttpResponseExceptionFactory ... exceptionFactories) {
        this.exceptionFactories = exceptionFactories;
    }

    @Override
    public IOException execute(ICanceler canceler, String url, int statusCode, String statusMessage, String contentType, String contentEncoding, InputStream inputStream) throws IOException, CanceledException {
        for (IApplicableHttpResponseExceptionFactory exceptionFactory : this.exceptionFactories) {
            if (!exceptionFactory.isApplicable(contentType)) continue;
            return exceptionFactory.create(statusCode, statusMessage, contentEncoding, inputStream);
        }
        byte[] array = IoUtilities.toByteArray((InputStream)inputStream);
        throw new HttpResponseException("Unexpected response content type '" + contentType + "'", url, statusCode, statusMessage, array, contentType, contentEncoding);
    }
}

