/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import net.anwiba.commons.http.Authentication;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpProxyConfiguration;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;

public class HttpClientConfigurationBuilder {
    final PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;
    private IHttpProxyConfiguration proxyConfiguration = null;
    private ConfigMode configMode = ConfigMode.useAlwaysANewConnection;
    private String userAgent = null;

    public HttpClientConfigurationBuilder() {
        this.poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
    }

    public HttpClientConfigurationBuilder(IHttpClientConfiguration configuration) {
        this.userAgent = configuration.getUserAgent();
        this.proxyConfiguration = (IHttpProxyConfiguration)configuration.getProxyConfiguration().get();
        this.configMode = configuration.getConfigMode();
        this.poolingHttpClientConnectionManager = this.configMode == ConfigMode.usePoolingConnection ? (PoolingHttpClientConnectionManager)configuration.getManager() : new PoolingHttpClientConnectionManager();
    }

    public HttpClientConfigurationBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HttpClientConfigurationBuilder setProxy(String scheme, String hostname, int port) {
        return this.setProxy(scheme, hostname, port, null, null);
    }

    public HttpClientConfigurationBuilder setProxy(final String scheme, final String hostname, final int port, String username, String password) {
        final Authentication authentication = username == null || password == null ? null : new Authentication(username, password);
        this.proxyConfiguration = new IHttpProxyConfiguration(){

            @Override
            public int getPort() {
                return port;
            }

            @Override
            public String getHost() {
                return hostname;
            }

            @Override
            public String getScheme() {
                return scheme;
            }

            @Override
            public IOptional<IAuthentication, RuntimeException> getAuthentication() {
                return Optional.of((Object)authentication);
            }
        };
        return this;
    }

    public HttpClientConfigurationBuilder usePoolingConnection() {
        this.configMode = ConfigMode.usePoolingConnection;
        return this;
    }

    public HttpClientConfigurationBuilder useAlwaysTheSameConnection() {
        this.configMode = ConfigMode.useAlwaysTheSameConnection;
        return this;
    }

    public HttpClientConfigurationBuilder useAlwaysANewConnection() {
        this.configMode = ConfigMode.useAlwaysANewConnection;
        return this;
    }

    public IHttpClientConfiguration build() {
        return this.create();
    }

    private IHttpClientConfiguration create() {
        return switch (this.configMode) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigMode.useAlwaysANewConnection -> new IHttpClientConfiguration(){

                @Override
                public ConfigMode getConfigMode() {
                    return HttpClientConfigurationBuilder.this.configMode;
                }

                @Override
                public HttpConnectionMode getMode() {
                    return HttpConnectionMode.CLOSE;
                }

                @Override
                public synchronized HttpClientConnectionManager getManager() {
                    return new BasicHttpClientConnectionManager();
                }

                @Override
                public IOptional<IHttpProxyConfiguration, RuntimeException> getProxyConfiguration() {
                    return Optional.of((Object)HttpClientConfigurationBuilder.this.proxyConfiguration);
                }

                @Override
                public synchronized void close() {
                }

                @Override
                public String getUserAgent() {
                    return HttpClientConfigurationBuilder.this.userAgent;
                }
            };
            case ConfigMode.useAlwaysTheSameConnection -> new IHttpClientConfiguration(){
                final HttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager();

                @Override
                public ConfigMode getConfigMode() {
                    return HttpClientConfigurationBuilder.this.configMode;
                }

                @Override
                public HttpConnectionMode getMode() {
                    return HttpConnectionMode.KEEP_ALIVE;
                }

                @Override
                public IOptional<IHttpProxyConfiguration, RuntimeException> getProxyConfiguration() {
                    return Optional.of((Object)HttpClientConfigurationBuilder.this.proxyConfiguration);
                }

                @Override
                public HttpClientConnectionManager getManager() {
                    return this.httpClientConnectionManager;
                }

                @Override
                public void close() {
                    try {
                        this.httpClientConnectionManager.close();
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public String getUserAgent() {
                    return HttpClientConfigurationBuilder.this.userAgent;
                }
            };
            case ConfigMode.usePoolingConnection -> new IHttpClientConfiguration(){

                @Override
                public ConfigMode getConfigMode() {
                    return HttpClientConfigurationBuilder.this.configMode;
                }

                @Override
                public HttpConnectionMode getMode() {
                    return HttpConnectionMode.KEEP_ALIVE;
                }

                @Override
                public HttpClientConnectionManager getManager() {
                    return HttpClientConfigurationBuilder.this.poolingHttpClientConnectionManager;
                }

                @Override
                public IOptional<IHttpProxyConfiguration, RuntimeException> getProxyConfiguration() {
                    return Optional.of((Object)HttpClientConfigurationBuilder.this.proxyConfiguration);
                }

                @Override
                public void close() {
                }

                @Override
                public String getUserAgent() {
                    return HttpClientConfigurationBuilder.this.userAgent;
                }
            };
        };
    }

    static enum ConfigMode {
        usePoolingConnection,
        useAlwaysTheSameConnection,
        useAlwaysANewConnection;

    }
}

