/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.util.Optional;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpClientFactory;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;

public class HttpClientFactory
implements IHttpClientFactory {
    @Override
    public CloseableHttpClient create(IHttpClientConfiguration configuration) {
        HttpClientBuilder builder = HttpClients.custom().setUserAgent(null).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).setConnectionManager(configuration.getManager());
        Optional.ofNullable(configuration.getUserAgent()).ifPresent(value -> builder.setUserAgent(value));
        return switch (configuration.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case HttpConnectionMode.CLOSE -> builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    return TimeValue.ZERO_MILLISECONDS;
                }
            }).setConnectionReuseStrategy(new ConnectionReuseStrategy(){

                public boolean keepAlive(HttpRequest request, HttpResponse response, HttpContext context) {
                    return false;
                }
            }).build();
            case HttpConnectionMode.KEEP_ALIVE -> builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE).build();
        };
    }
}

