/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.anwiba.commons.http.HttpMethodType;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.parameter.ParametersBuilder;
import net.anwiba.commons.reference.url.IUrl;
import net.anwiba.commons.reference.url.builder.UrlBuilder;
import net.anwiba.commons.reference.url.parser.UrlParser;
import net.anwiba.commons.reference.utilities.IoUtilities;

public class HttpRequestCacheKey {
    private final String url;
    private final String body;

    private HttpRequestCacheKey(String url, String body) {
        this.url = url;
        this.body = body;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpRequestCacheKey other = (HttpRequestCacheKey)obj;
        return Objects.equals(this.url, other.url) && Objects.equals(this.body, other.body);
    }

    public static IOptional<HttpRequestCacheKey, RuntimeException> of(IRequest request) {
        try {
            IParameters parameters = request.getParameters();
            ParametersBuilder builder = ParametersBuilder.of((IParameters)parameters);
            String body = HttpRequestCacheKey.getBody(request);
            request.getProperties().getParameter("Authorization").consume(arg_0 -> ((ParametersBuilder)builder).add(arg_0));
            request.getProperties().getParameter("Content-Type").consume(arg_0 -> ((ParametersBuilder)builder).add(arg_0));
            String url = HttpRequestCacheKey.createUrl(request.getUriString(), builder.build());
            return Optional.of((Object)new HttpRequestCacheKey(url, body));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    private static String getBody(IRequest request) throws IOException {
        if (Objects.equals((Object)request.getMethodType(), (Object)HttpMethodType.POST)) {
            return (String)request.getContent(stream -> IoUtilities.toString((InputStream)stream, (String)"UTF-8"));
        }
        return null;
    }

    private static String createUrl(String uriString, IParameters parameters) {
        try {
            IUrl url = new UrlParser().parse(uriString);
            UrlBuilder builder = new UrlBuilder(url);
            parameters.forEach(p -> builder.addQueryParameter(p));
            return builder.build().toString();
        }
        catch (CreationException e) {
            return uriString;
        }
    }
}

