/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Objects;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpClientFactory;
import net.anwiba.commons.http.IHttpRequestExecutor;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.http.Response;
import net.anwiba.commons.http.StatusCodes;
import net.anwiba.commons.http.apache.HttpContextFactory;
import net.anwiba.commons.http.apache.RequestToHttpUriRequestConverter;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.IObserver;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpResponse;

public class HttpRequestExecutor
implements IHttpRequestExecutor {
    private static ILogger logger = Logging.getLogger((String)HttpRequestExecutor.class.getName());
    private final RequestToHttpUriRequestConverter requestToHttpUriRequestConverter;
    private final HttpContextFactory httpContextFactory;
    private final IHttpClientFactory httpClientFactory;
    private CloseableHttpClient client;
    private boolean isClosed = false;
    private final IHttpClientConfiguration configuration;

    HttpRequestExecutor(IHttpClientFactory httpClientFactory, HttpContextFactory httpContextFactory, RequestToHttpUriRequestConverter requestToHttpUriRequestConverter, IHttpClientConfiguration configuration) {
        this.configuration = configuration;
        this.requestToHttpUriRequestConverter = requestToHttpUriRequestConverter;
        this.httpContextFactory = httpContextFactory;
        this.httpClientFactory = httpClientFactory;
    }

    @Override
    public IResponse execute(ICanceler canceler, IRequest request) throws CanceledException, IOException {
        if (this.isClosed) {
            throw new IOException("executor is closed");
        }
        LocalTime now = LocalTime.now();
        try {
            this.client = this.client == null ? this.httpClientFactory.create(this.configuration) : this.client;
            HttpUriRequest uriRequest = this.requestToHttpUriRequestConverter.convert(request);
            logger.log(ILevel.DEBUG, () -> MessageFormat.format("request url: <{0}>", uriRequest.getRequestUri()));
            canceler.check();
            HttpResponse httpResponse = this.query(canceler, this.client, request, uriRequest);
            if (HttpConnectionMode.CLOSE.equals((Object)this.configuration.getMode())) {
                Response response = new Response(canceler, (Closeable)this.client, uriRequest, httpResponse);
                logger.log(ILevel.DEBUG, () -> MessageFormat.format("requested duration: {2} code <{1}> url: <{0}>", response.getUri(), response.getStatusCode(), Duration.between(now, LocalTime.now())));
                this.client = null;
                return response;
            }
            Response response = new Response(canceler, () -> {}, uriRequest, httpResponse);
            logger.log(ILevel.DEBUG, () -> MessageFormat.format("requested duration: {2} code <{1}> url: <{0}>", response.getUri(), response.getStatusCode(), Duration.between(now, LocalTime.now())));
            return response;
        }
        catch (IOException exception) {
            if (exception instanceof InterruptedIOException) {
                logger.log(ILevel.DEBUG, () -> MessageFormat.format("request canceled after: {1} url: <{0}>", request.getUriString(), Duration.between(now, LocalTime.now())));
                throw new CanceledException(exception.getMessage(), (Throwable)exception);
            }
            throw exception;
        }
        catch (IllegalStateException | ConversionException exception) {
            logger.log(ILevel.ALL, () -> HttpRequestExecutor.lambda$execute$5(request, now, (Exception)exception), exception);
            throw new IOException(exception.getMessage(), exception);
        }
    }

    private HttpResponse query(ICanceler canceler, CloseableHttpClient httpClient, IRequest request, HttpUriRequest httpUriRequest) throws IOException, ClientProtocolException {
        try (IObserver observer = canceler.observer(() -> httpUriRequest.abort());){
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpUriRequest, this.httpContextFactory.create(this.configuration, request));
            if (StatusCodes.isRedirection(response.getCode()) && Objects.equals(response.getFirstHeader("Connection").getValue().toLowerCase(), "closed")) {
                response.getHeaders();
            }
            CloseableHttpResponse closeableHttpResponse = response;
            return closeableHttpResponse;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            IoUtilities.closeAndThrow(() -> this.configuration.close(), (Closeable)this.client, (Closeable[])new Closeable[0]);
        }
        finally {
            this.isClosed = true;
            this.client = null;
        }
    }

    private static /* synthetic */ String lambda$execute$5(IRequest request, LocalTime now, Exception exception) {
        return MessageFormat.format("request failed after: {1} url: <{0}>, because {2}", request.getUriString(), Duration.between(now, LocalTime.now()), exception.getMessage());
    }
}

