/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import net.anwiba.commons.http.HttpClientConfigurationBuilder;
import net.anwiba.commons.http.HttpRequestExecutorFactory;
import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpRequestExecutorFactory;
import net.anwiba.commons.http.IHttpRequestExecutorFactoryBuilder;

public class HttpRequestExecutorFactoryBuilder
implements IHttpRequestExecutorFactoryBuilder {
    private HttpClientConfigurationBuilder builder;

    public HttpRequestExecutorFactoryBuilder() {
        this.builder = new HttpClientConfigurationBuilder();
    }

    public HttpRequestExecutorFactoryBuilder(IHttpClientConfiguration configuration) {
        this.builder = new HttpClientConfigurationBuilder(configuration);
    }

    @Override
    public HttpRequestExecutorFactoryBuilder setUserAgent(String userAgent) {
        this.builder.setUserAgent(userAgent);
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder setProxy(String scheme, String hostname, int port) {
        this.builder.setProxy(scheme, hostname, port);
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder setProxy(String scheme, String hostname, int port, String username, String password) {
        this.builder.setProxy(scheme, hostname, port, username, password);
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder usePoolingConnection() {
        this.builder.usePoolingConnection();
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder useAlwaysTheSameConnection() {
        this.builder.useAlwaysTheSameConnection();
        return this;
    }

    @Override
    public IHttpRequestExecutorFactoryBuilder useAlwaysANewConnection() {
        this.builder.useAlwaysANewConnection();
        return this;
    }

    @Override
    public IHttpRequestExecutorFactory build() {
        return new HttpRequestExecutorFactory(() -> this.builder.build());
    }
}

