/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.http.HttpRequestException;
import net.anwiba.commons.http.IResponse;
import net.anwiba.commons.reference.utilities.IoUtilities;

public class HttpResponseException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final int statusCode;
    private final String statusText;
    private final byte[] content;
    private final String contentType;
    private final String contentEncoding;
    private String url;

    public HttpResponseException(String message, String url, int statusCode, String statusText, byte[] content, String contentType, String contentEncoding) {
        super(message);
        this.url = url;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.content = content;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    public HttpResponseException(String message, String url, int statusCode, String statusText, byte[] content, String contentType, String contentEncoding, Throwable throwable) {
        super(message, throwable);
        this.url = url;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.content = content;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getContentLength() {
        return this.content == null ? 0 : this.content.length;
    }

    public String getContentAsString() {
        if (this.contentEncoding == null || this.content == null || this.content.length == 0) {
            return "";
        }
        try {
            return new String(this.content, this.contentEncoding);
        }
        catch (IOException exception) {
            return new String(this.content);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public static HttpResponseException create(String message, IResponse response, byte[] body) {
        return new HttpResponseException(message, response.getUri(), response.getStatusCode(), response.getStatusText(), body, response.getContentType(), response.getContentEncoding());
    }

    public static IOException create(String message, IResponse response) throws IOException {
        if (response.getContentLength() == 0L) {
            return new HttpRequestException(message, response.getUri(), response.getStatusCode(), response.getStatusText());
        }
        try (InputStream inputStream = response.getInputStream();){
            HttpResponseException httpResponseException = new HttpResponseException(message, response.getUri(), response.getStatusCode(), response.getStatusText(), IoUtilities.toByteArray((InputStream)inputStream), response.getContentType(), response.getContentEncoding());
            return httpResponseException;
        }
    }
}

