/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.cache.resource.ILifeTime;
import net.anwiba.commons.http.HttpMethodType;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.lang.functional.IClosure;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.parameter.IParameters;

public interface IRequest {
    public HttpMethodType getMethodType();

    public String getUriString();

    public IAuthentication getAuthentication();

    public IParameters getParameters();

    public long getContentLength();

    public IClosure<InputStream, IOException> getContent();

    default public <T> T getContent(IConverter<InputStream, T, IOException> converter) throws IOException {
        try (InputStream stream = (InputStream)this.getContent().execute();){
            Object object = converter.convert((Object)stream);
            return (T)object;
        }
    }

    default public void getContent(IConsumer<InputStream, IOException> converter) throws IOException {
        try (InputStream stream = (InputStream)this.getContent().execute();){
            converter.consume((Object)stream);
        }
    }

    public String getContentMimeType();

    public String getContentCharset();

    public IParameters getProperties();

    public String getHost();

    public int getPort();

    default public IOptional<ILifeTime, RuntimeException> getCacheTime() {
        return Optional.empty();
    }
}

