/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.apache;

import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IHttpClientConfiguration;
import net.anwiba.commons.http.IHttpProxyConfiguration;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.lang.optional.Optional;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.protocol.HttpContext;

public final class HttpContextFactory {
    public HttpContext create(IHttpClientConfiguration configuration, IRequest request) {
        HttpClientContext context = HttpClientContext.create();
        BasicAuthCache authCache = new BasicAuthCache();
        if (request.getAuthentication() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            this.addAuthentificationCredentialsTo(request.getHost(), request.getPort(), request.getAuthentication(), (AuthCache)authCache, credentialsProvider);
            configuration.getProxyConfiguration().consume(arg_0 -> this.lambda$create$1((AuthCache)authCache, credentialsProvider, arg_0));
            context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            context.setAuthCache((AuthCache)authCache);
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        configuration.getProxyConfiguration().consume(c -> this.addProxies(builder, (IHttpProxyConfiguration)c));
        context.setRequestConfig(builder.build());
        return context;
    }

    private void addProxies(RequestConfig.Builder builder, IHttpProxyConfiguration configuration) {
        builder.setProxy(new HttpHost(configuration.getScheme(), configuration.getHost(), configuration.getPort()));
    }

    private void addAuthentificationCredentialsTo(String host, int port, IAuthentication authentication, AuthCache authCache, BasicCredentialsProvider credentialsProvider) {
        if (authentication == null) {
            return;
        }
        char[] password = (char[])Optional.of((Object)authentication.getPassword()).convert(p -> p.toCharArray()).get();
        HttpHost httpHost = new HttpHost(URIScheme.HTTP.getId(), host, port);
        HttpHost httpsHost = new HttpHost(URIScheme.HTTPS.getId(), host, port);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(authentication.getUsername(), password);
        credentialsProvider.setCredentials(new AuthScope(httpHost), (Credentials)credentials);
        credentialsProvider.setCredentials(new AuthScope(httpsHost), (Credentials)credentials);
        BasicScheme authScheme = new BasicScheme();
        if (authentication.isPreemptive() || authentication.isForces()) {
            authScheme.initPreemptive((Credentials)credentials);
        }
        authCache.put(httpHost, (AuthScheme)authScheme);
        authCache.put(httpsHost, (AuthScheme)authScheme);
    }

    private /* synthetic */ void lambda$create$1(AuthCache authCache, BasicCredentialsProvider credentialsProvider, IHttpProxyConfiguration c) throws RuntimeException {
        c.getAuthentication().consume(a -> this.addAuthentificationCredentialsTo(c.getHost(), c.getPort(), (IAuthentication)a, authCache, credentialsProvider));
    }
}

