/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http.apache;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import net.anwiba.commons.http.HttpConnectionMode;
import net.anwiba.commons.http.IAuthentication;
import net.anwiba.commons.http.IRequest;
import net.anwiba.commons.http.apache.InputStreamEntity;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.reference.url.IUrl;
import net.anwiba.commons.reference.url.builder.UrlBuilder;
import net.anwiba.commons.reference.url.parser.UrlParser;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.utils.ByteArrayBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;

public final class RequestToHttpUriRequestConverter {
    private final HttpConnectionMode httpConnectionMode;

    public RequestToHttpUriRequestConverter(HttpConnectionMode httpConnectionMode) {
        this.httpConnectionMode = httpConnectionMode;
    }

    public HttpUriRequest convert(IRequest request) throws ConversionException {
        try {
            IUrl parsedUrl = new UrlParser().parse(request.getUriString());
            UrlBuilder urlBuilder = new UrlBuilder(parsedUrl);
            request.getParameters().forEach(arg_0 -> ((UrlBuilder)urlBuilder).addQueryParameter(arg_0));
            IUrl url = urlBuilder.build();
            switch (request.getMethodType()) {
                case POST: {
                    HttpPost post = new HttpPost(url.encoded());
                    this.addToHeader(request.getAuthentication(), request.getProperties().parameters(), (HttpMessage)post);
                    HttpEntity entity = this.createEntity(request);
                    post.setEntity(entity);
                    return post;
                }
                case GET: {
                    HttpGet get = new HttpGet(url.encoded());
                    this.addToHeader(request.getAuthentication(), request.getProperties().parameters(), (HttpMessage)get);
                    return get;
                }
            }
        }
        catch (IllegalArgumentException | CreationException exception) {
            throw new ConversionException("Couldn't convert reqeut to appache http request.", exception);
        }
        throw new UnreachableCodeReachedException();
    }

    private void addToHeader(IAuthentication authentication, Iterable<IParameter> parameters, HttpMessage requestBuilder) {
        for (IParameter parameter : parameters) {
            if (Objects.equals("Connection", parameter.getName()) && HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode)) continue;
            requestBuilder.addHeader(parameter.getName(), (Object)parameter.getValue());
        }
        if (HttpConnectionMode.CLOSE.equals((Object)this.httpConnectionMode)) {
            requestBuilder.addHeader("Connection", (Object)"close");
        }
        Optional.ofNullable(authentication).filter(a -> a.isForces()).ifPresent(a -> requestBuilder.addHeader("Authorization", (Object)this.toBasicSchema(authentication)));
    }

    private String toBasicSchema(IAuthentication authentication) {
        ByteArrayBuilder buffer = new ByteArrayBuilder(64).charset(StandardCharsets.US_ASCII);
        buffer.append(authentication.getUsername()).append(":").append(authentication.getPassword());
        byte[] encodedCreds = Base64.getEncoder().encode(buffer.toByteArray());
        return "Basic " + new String(encodedCreds, 0, encodedCreds.length, StandardCharsets.US_ASCII);
    }

    private HttpEntity createEntity(IRequest request) {
        String charsetName = request.getContentCharset();
        Charset charset = charsetName == null ? null : Charset.forName(charsetName);
        ContentType contentType = ContentType.create((String)request.getContentMimeType(), (Charset)charset);
        return new InputStreamEntity(request.getContent(), request.getContentLength(), contentType, charsetName);
    }
}

