/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.pnm;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import net.anwiba.commons.reference.utilities.IoUtilities;

public class AsciiPnmReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Number[][] read(URL resource) throws IOException {
        Number[][] numberArray;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(resource.openStream()));
            Number[][] values = new Number[][]{};
            String line = null;
            line = reader.readLine();
            if (line == null || !line.equals("P2")) {
                throw new IOException();
            }
            while ((line = reader.readLine()) != null) {
                if (line.charAt(0) == '#') continue;
                values = this.createArray(line);
                break;
            }
            while ((line = reader.readLine()) != null && line.charAt(0) == '#') {
            }
            int i = 0;
            int j = 0;
            while (true) {
                if ((line = reader.readLine()) == null || i >= values.length) {
                    numberArray = values;
                    break;
                }
                if (line.charAt(0) == '#') continue;
                values[i][j] = this.createValue(line);
                if (++j < values[i].length) continue;
                j = 0;
                ++i;
            }
        }
        catch (Throwable throwable) {
            IoUtilities.close(reader);
            throw throwable;
        }
        IoUtilities.close((Closeable)reader);
        return numberArray;
    }

    private Number createValue(String line) {
        return Integer.valueOf(line);
    }

    private Number[][] createArray(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        int j = Integer.parseInt(tokenizer.nextToken());
        int i = Integer.parseInt(tokenizer.nextToken());
        return new Number[i][j];
    }
}

