/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ScaleDescriptor;

public class ImageContainerUtilities {
    public static RenderedOp crop(RenderedImage renderedImage, float x, float y, float width, float height) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(renderedImage);
        pb.add(x);
        pb.add(y);
        pb.add(width);
        pb.add(height);
        return JAI.create((String)"Crop", (ParameterBlock)pb);
    }

    public static RenderedOp translate(RenderedImage renderedImage, float x, float y) {
        ParameterBlock params = new ParameterBlock();
        params.addSource(renderedImage);
        params.add(x);
        params.add(y);
        return JAI.create((String)"Translate", (ParameterBlock)params);
    }

    public static RenderedOp scale(RenderedImage renderedOp, float factor) {
        return ImageContainerUtilities.scale(renderedOp, factor, factor);
    }

    public static RenderedOp scale(RenderedImage renderedImage, float xFactor, float yFactor) {
        return ScaleDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(xFactor), (Float)Float.valueOf(yFactor), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
    }

    public static PlanarImage toGrayScale(RenderedImage image) {
        double[][] matrix;
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        ImageLayout imageLayout = new ImageLayout(image);
        imageLayout.setColorModel((ColorModel)colorModel);
        imageLayout.setSampleModel(((ColorModel)colorModel).createCompatibleSampleModel(image.getWidth(), image.getHeight()));
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        int expandedNumBands = OpImage.getExpandedNumBands((SampleModel)image.getSampleModel(), (ColorModel)image.getColorModel()) + 1;
        switch (expandedNumBands) {
            case 5: {
                matrix = new double[][]{{0.114, 0.587, 0.299, 0.0, 0.0}};
                break;
            }
            case 4: {
                matrix = new double[][]{{0.114, 0.587, 0.299, 0.0}};
                break;
            }
            case 3: {
                matrix = new double[][]{{0.114, 0.587, 0.299}};
                break;
            }
            case 2: {
                matrix = new double[][]{{1.0, 0.0}};
                break;
            }
            default: {
                matrix = new double[][]{{1.0}};
            }
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(matrix);
        return JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)renderingHints);
    }
}

