/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.ImageContainerUtilities;
import net.anwiba.commons.image.PlanarImageContainer;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IResourceReferenceFactory;
import net.anwiba.commons.resource.reference.IResourceReferenceHandler;
import net.anwiba.commons.resource.utilities.IoUtilities;

public final class ImageReader {
    private final IResourceReferenceFactory factory;
    private final IResourceReferenceHandler handler;

    public ImageReader(IResourceReferenceFactory factory, IResourceReferenceHandler handler) {
        this.factory = factory;
        this.handler = handler;
    }

    public BufferedImage scale(URL resource, float factor) throws IOException {
        IResourceReference resourceReference = this.factory.create(resource);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            BufferedImage image;
            InputStream stream = this.handler.openInputStream(resourceReference);
            RenderedOp scaledRenderedOp = ImageContainerUtilities.scale((RenderedImage)this.createRenderOp(stream), factor);
            BufferedImage bufferedImage = image = scaledRenderedOp.getAsBufferedImage();
            return bufferedImage;
            {
                finally {
                    scaledRenderedOp.dispose();
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public BufferedImage readBufferedImage(File file) throws IOException {
        try {
            IResourceReference resourceReference = this.factory.create(file);
            return this.readBufferedImage(ICanceler.DummyCancler, resourceReference);
        }
        catch (InterruptedException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    public BufferedImage readBufferedImage(URI uri) throws IOException {
        try {
            IResourceReference resourceReference = this.factory.create(uri);
            return this.readBufferedImage(ICanceler.DummyCancler, resourceReference);
        }
        catch (InterruptedException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    public BufferedImage readBufferedImage(ICanceler canceler, URL resource) throws InterruptedException, IOException {
        IResourceReference resourceReference = this.factory.create(resource);
        return this.readBufferedImage(canceler, resourceReference);
    }

    public BufferedImage readBufferedImage(ICanceler canceler, IResourceReference resourceReference) throws InterruptedException, IOException {
        canceler.check();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream stream = this.handler.openInputStream(resourceReference);){
            return this.readBufferedImage(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public BufferedImage readBufferedImage(ICanceler canceler, InputStream inputStream) throws InterruptedException, IOException {
        canceler.check();
        return this.readBufferedImage(inputStream);
    }

    public BufferedImage readBufferedImage(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage;
        RenderedOp renderedOp = this.createRenderOp(inputStream);
        try {
            bufferedImage = renderedOp.getAsBufferedImage();
        }
        catch (Throwable throwable) {
            try {
                renderedOp.dispose();
                throw throwable;
            }
            catch (RuntimeException exception) {
                throw new IOException(exception);
            }
        }
        renderedOp.dispose();
        return bufferedImage;
    }

    public IImageContainer read(ICanceler canceler, URL resource) throws InterruptedException, IOException {
        return this.read(canceler, this.factory.create(resource));
    }

    public IImageContainer read(ICanceler canceler, IResourceReference resourceReference) throws InterruptedException, IOException {
        canceler.check();
        if (this.handler.isFileSystemResource(resourceReference)) {
            return this.read(canceler, this.handler.openInputStream(resourceReference));
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream stream = this.handler.openInputStream(resourceReference);){
            return this.read(canceler, IoUtilities.copy((InputStream)stream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IImageContainer read(ICanceler canceler, InputStream inputStream) throws InterruptedException {
        canceler.check();
        return new PlanarImageContainer((PlanarImage)this.createRenderOp(inputStream));
    }

    private RenderedOp createRenderOp(InputStream inputStream) {
        MemoryCacheSeekableStream memoryCacheSeekableStream = new MemoryCacheSeekableStream(inputStream);
        return JAI.create((String)"Stream", (Object)memoryCacheSeekableStream);
    }

    public IImageContainer createImageContainer(File file) throws IOException {
        return new PlanarImageContainer((PlanarImage)this.createRenderOp(new FileInputStream(file)));
    }
}

