/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import net.anwiba.commons.image.AbstractRenderedImageContainer;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class PlanarImageContainer
extends AbstractRenderedImageContainer {
    private static ILogger logger = Logging.getLogger(PlanarImageContainer.class);
    final PlanarImage image;

    public PlanarImageContainer(PlanarImage image) {
        super((RenderedImage)image);
        this.image = image;
    }

    @Override
    public BufferedImage asBufferImage() {
        try {
            return this.image.getAsBufferedImage();
        }
        catch (RuntimeException exception) {
            logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public void dispose() {
        this.image.dispose();
    }

    @Override
    public BufferedImage asBufferImage(int x, int y, int w, int h) {
        return this.image.getAsBufferedImage(new Rectangle(x, y, w, h), null);
    }
}

