/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.ImageContainerUtilities;
import net.anwiba.commons.image.PlanarImageContainer;

public abstract class AbstractRenderedImageContainer
implements IImageContainer {
    private final RenderedImage image;

    public AbstractRenderedImageContainer(RenderedImage image) {
        this.image = image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public IImageContainer crop(float x, float y, float width, float height) {
        RenderedOp cropedRenderOp = ImageContainerUtilities.crop(this.image, x, y, width, height);
        RenderedOp translateedRenderOp = ImageContainerUtilities.translate((RenderedImage)cropedRenderOp, -x, -y);
        return new PlanarImageContainer((PlanarImage)translateedRenderOp);
    }

    @Override
    public IImageContainer scale(float factor) {
        return this.scale(factor, factor);
    }

    @Override
    public IImageContainer scale(float widthFactor, float heightFactor) {
        RenderedOp scaledRenderOp = ImageContainerUtilities.scale(this.image, widthFactor, heightFactor);
        return new PlanarImageContainer((PlanarImage)scaledRenderOp);
    }

    @Override
    public IImageContainer fit(int width, int height) {
        float factor = this.fitFactor(width, height);
        return this.scale(factor);
    }

    @Override
    public BufferedImage asBufferImage(Rectangle rectangle) {
        return this.asBufferImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private float fitFactor(int width, int height) {
        float withFactor = this.factor(width, this.getWidth());
        float heightfactor = this.factor(height, this.getHeight());
        return Math.max(withFactor, heightfactor);
    }

    private float factor(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }
}

