/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.anwiba.commons.image.ImageCodecVisitor;
import net.anwiba.commons.image.codec.ImageCodec;
import net.anwiba.commons.image.encoder.IEncoder;
import net.anwiba.commons.image.encoder.JpegEncoder;
import net.anwiba.commons.image.encoder.PngEncoder;
import net.anwiba.commons.resource.utilities.FileUtilities;

public class ImageWriter {
    public void write(BufferedImage image, File file) throws IOException {
        IEncoder encoder = this.getEncoder(FileUtilities.getExtension((File)file));
        this.write(image, file, encoder);
    }

    private IEncoder getEncoder(String extension) {
        ImageCodecVisitor visitor = new ImageCodecVisitor();
        return ImageCodec.getByExtension(extension).accept(visitor);
    }

    public void writeAsPng(BufferedImage image, File file) throws IOException {
        this.write(image, file, new PngEncoder());
    }

    public void writeAsJpeg(BufferedImage image, File file) throws IOException {
        this.write(image, file, new JpegEncoder());
    }

    private void write(BufferedImage image, File file, IEncoder encoder) throws IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            encoder.encode(image, out);
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(out.toByteArray());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

