/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ScaleDescriptor;

public class ImageContainerUtilities {
    public static RenderedOp crop(RenderedImage renderedImage, float x, float y, float width, float height) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(renderedImage);
        pb.add(x);
        pb.add(y);
        pb.add(width);
        pb.add(height);
        return JAI.create((String)"Crop", (ParameterBlock)pb);
    }

    public static RenderedOp translate(RenderedImage renderedImage, float x, float y) {
        ParameterBlock params = new ParameterBlock();
        params.addSource(renderedImage);
        params.add(x);
        params.add(y);
        return JAI.create((String)"Translate", (ParameterBlock)params);
    }

    public static RenderedOp scale(RenderedImage renderedOp, float factor) {
        return ImageContainerUtilities.scale(renderedOp, factor, factor);
    }

    public static RenderedOp scale(RenderedImage renderedImage, float xFactor, float yFactor) {
        return ScaleDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(xFactor), (Float)Float.valueOf(yFactor), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
    }
}

