/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.ImageReader;
import net.anwiba.commons.process.cancel.ICanceler;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IResourceReferenceFactory;
import net.anwiba.commons.resource.reference.IResourceReferenceHandler;
import net.anwiba.commons.resource.reference.ResourceReferenceFactory;
import net.anwiba.commons.resource.reference.ResourceReferenceHandler;

public class ImageReaderUtilities {
    private static final ImageReader imageReader = new ImageReader((IResourceReferenceFactory)new ResourceReferenceFactory(), (IResourceReferenceHandler)new ResourceReferenceHandler());

    public static BufferedImage scale(URL resource, float factor) throws IOException {
        return imageReader.scale(resource, factor);
    }

    public static BufferedImage readBufferedImage(File file) throws IOException {
        return imageReader.readBufferedImage(file);
    }

    public static BufferedImage readBufferedImage(URI uri) throws IOException {
        return imageReader.readBufferedImage(uri);
    }

    public static BufferedImage readBufferedImage(ICanceler canceler, URL resource) throws InterruptedException, IOException {
        return imageReader.readBufferedImage(canceler, resource);
    }

    public static BufferedImage readBufferedImage(ICanceler canceler, IResourceReference resourceReference) throws InterruptedException, IOException {
        return imageReader.readBufferedImage(canceler, resourceReference);
    }

    public static BufferedImage readBufferedImage(InputStream inputStream) throws IOException {
        return imageReader.readBufferedImage(inputStream);
    }

    public static BufferedImage readBufferedImage(ICanceler canceler, InputStream inputStream) throws InterruptedException, IOException {
        return imageReader.readBufferedImage(canceler, inputStream);
    }

    public static IImageContainer read(ICanceler canceler, URL resource) throws InterruptedException, IOException {
        return imageReader.read(canceler, resource);
    }

    public static IImageContainer read(ICanceler canceler, IResourceReference resourceReference) throws InterruptedException, IOException {
        return imageReader.read(canceler, resourceReference);
    }

    public static IImageContainer read(ICanceler canceler, InputStream inputStream) throws InterruptedException {
        return imageReader.read(canceler, inputStream);
    }

    public static IImageContainer createImageContainer(File file) throws IOException {
        return imageReader.createImageContainer(file);
    }
}

