/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.InvalidImageMetadata;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageCropOperation;
import net.anwiba.commons.image.operation.ImageInvertOperation;
import net.anwiba.commons.image.operation.ImageMapBandsOperation;
import net.anwiba.commons.image.operation.ImageOpacityOperation;
import net.anwiba.commons.image.operation.ImageScaleOperation;
import net.anwiba.commons.image.operation.ImageToGrayScaleOperation;
import net.anwiba.commons.lang.collection.IMutableObjectList;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.collection.ObjectListBuilder;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.thread.cancel.ICanceler;

public abstract class AbstractImageContainer
implements IImageContainer {
    private static ILogger logger = Logging.getLogger(AbstractImageContainer.class);
    private final IMutableObjectList<IImageOperation> operations = new ObjectList();
    private IImageMetadata metadata;
    private final RenderingHints hints;
    private IImageMetadataAdjustor metadataAdjustor;

    public AbstractImageContainer(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        this.hints = hints;
        this.metadata = metadata;
        this.metadataAdjustor = metadataAdjustor;
        this.operations.add(operations);
    }

    @Override
    public BufferedImage asBufferImage(IMessageCollector messageCollector, ICanceler canceler) throws CanceledException {
        try {
            BufferedImage image = this.read(messageCollector, canceler, this.hints, (IObjectList<IImageOperation>)this.operations, this.metadataAdjustor);
            canceler.check();
            return image;
        }
        catch (IllegalArgumentException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            messageCollector.addMessage(Message.builder().setText(exception.getMessage()).setThrowable((Throwable)exception).setError().build());
            return null;
        }
        catch (IOException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            messageCollector.addMessage(Message.builder().setText(exception.getMessage()).setThrowable((Throwable)exception).setError().build());
            return null;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public final IImageContainer crop(Rectangle rectangle) {
        return this.crop(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public final IImageContainer crop(float x, float y, float width, float height) {
        return this.create(this.metadata, new ImageCropOperation(x, y, width, height));
    }

    @Override
    public final IImageContainer fitTo(int width, int height) {
        float withFactor = this.factor(width, this.getWidth());
        float heightfactor = this.factor(height, this.getHeight());
        return this.scale(Math.max(withFactor, heightfactor));
    }

    @Override
    public final IImageContainer scaleTo(int width, int height) {
        float withFactor = this.factor(width, this.getWidth());
        float heightfactor = this.factor(height, this.getHeight());
        return this.scale(withFactor, heightfactor);
    }

    private float factor(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    @Override
    public final IImageContainer scale(float factor) {
        return this.scale(factor, factor);
    }

    @Override
    public final IImageContainer scale(float widthFactor, float heightFactor) {
        return this.create(this.metadata, new ImageScaleOperation(widthFactor, heightFactor));
    }

    @Override
    public final IImageContainer opacity(float factor) {
        return this.create(this.metadata, new ImageOpacityOperation(factor));
    }

    @Override
    public final IImageContainer mapBands(int[] bandMapping) {
        return this.create(this.metadata, new ImageMapBandsOperation(bandMapping));
    }

    @Override
    public final IImageContainer invert() {
        return this.create(this.metadata, new ImageInvertOperation());
    }

    @Override
    public final IImageContainer toGrayScale() {
        return this.create(this.metadata, new ImageToGrayScaleOperation());
    }

    @Override
    public IImageContainer operation(IImageOperation operation) {
        return this.create(this.metadata, operation);
    }

    @Override
    public final IImageMetadata getMetadata() {
        try {
            if (this.metadata == null) {
                IImageMetadata metadata = this.read(ICanceler.DummyCanceler, this.hints);
                if (metadata == null) {
                    return new InvalidImageMetadata(new MessageBuilder().setText("Couldn't read image metadata").setError().build());
                }
                for (IImageOperation operation : this.operations) {
                    metadata = this.metadataAdjustor.adjust(metadata, operation);
                }
                this.metadata = metadata;
            }
            return this.metadata;
        }
        catch (IOException | CanceledException exception) {
            return new InvalidImageMetadata(new MessageBuilder().setText(exception.getMessage()).setThrowable(exception).setError().build());
        }
    }

    @Override
    public final int getColorSpaceType() {
        return this.getMetadata().getColorSpaceType();
    }

    @Override
    public int getWidth() {
        return Math.round(this.getMetadata().getWidth());
    }

    @Override
    public int getHeight() {
        return Math.round(this.getMetadata().getHeight());
    }

    @Override
    public final int getNumberOfComponents() {
        return this.getMetadata().getNumberOfColorComponents();
    }

    @Override
    public final int getNumberOfBands() {
        return this.getMetadata().getNumberOfBands();
    }

    private IImageContainer create(IImageMetadata metadata, IImageOperation operation) {
        return this.adapt(this.hints, metadata == null ? null : this.metadataAdjustor.adjust(metadata, operation), this.addTo((IObjectList<IImageOperation>)this.operations, operation), this.metadataAdjustor);
    }

    private IObjectList<IImageOperation> addTo(IObjectList<IImageOperation> operations, IImageOperation operation) {
        return new ObjectListBuilder(operations).add((Object)operation).build();
    }

    protected abstract IImageMetadata read(ICanceler var1, RenderingHints var2) throws CanceledException, IOException;

    protected abstract BufferedImage read(IMessageCollector var1, ICanceler var2, RenderingHints var3, IObjectList<IImageOperation> var4, IImageMetadataAdjustor var5) throws CanceledException, IOException;

    protected abstract IImageContainer adapt(RenderingHints var1, IImageMetadata var2, IObjectList<IImageOperation> var3, IImageMetadataAdjustor var4);
}

