/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;

public interface IImageContainer {
    default public BufferedImage asBufferImage() {
        try {
            return this.asBufferImage(ICanceler.DummyCanceler);
        }
        catch (CanceledException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    default public BufferedImage asBufferImage(ICanceler canceler) throws CanceledException {
        return this.asBufferImage(IMessageCollector.DummyCollector, canceler);
    }

    public BufferedImage asBufferImage(IMessageCollector var1, ICanceler var2) throws CanceledException;

    public IImageContainer crop(float var1, float var2, float var3, float var4);

    public IImageContainer crop(Rectangle var1);

    public IImageContainer fitTo(int var1, int var2);

    default public IImageContainer scale(double widthFactor, double heightFactor) {
        return this.scale(Double.valueOf(widthFactor).floatValue(), Double.valueOf(heightFactor).floatValue());
    }

    public IImageContainer scaleTo(int var1, int var2);

    public IImageContainer scale(float var1, float var2);

    public IImageContainer scale(float var1);

    public IImageContainer invert();

    public IImageContainer opacity(float var1);

    default public IImageContainer operation(IImageOperation operation) {
        return this;
    }

    public IImageContainer mapBands(int[] var1);

    public IImageContainer toGrayScale();

    public void dispose();

    public int getWidth();

    public int getHeight();

    public int getNumberOfComponents();

    public int getNumberOfBands();

    public int getColorSpaceType();

    default public boolean isScaleRecommended() {
        return false;
    }

    default public IImageMetadata getMetadata() {
        return null;
    }

    default public Number[] getValues(int x, int y) {
        return this.getValues(x, y, 1, 1)[0];
    }

    default public Number[][] getValues(int x, int y, int width, int height) {
        Raster raster = this.asBufferImage().getData(new Rectangle(x, y, width, height));
        raster.getDataElements(0, 0, width, height, null);
        return new Number[][]{new Number[0]};
    }
}

