/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.InvalidImageMetadata;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageCropOperation;
import net.anwiba.commons.image.operation.ImageInvertOperation;
import net.anwiba.commons.image.operation.ImageMapBandsOperation;
import net.anwiba.commons.image.operation.ImageOpacityOperation;
import net.anwiba.commons.image.operation.ImageScaleOperation;
import net.anwiba.commons.image.operation.ImageToGrayScaleOperation;
import net.anwiba.commons.message.MessageBuilder;

public interface IImageMetadataAdjustor {
    default public IImageMetadata adjust(IImageMetadata metadata, IImageOperation operation) {
        if (operation instanceof ImageScaleOperation) {
            ImageScaleOperation o = (ImageScaleOperation)operation;
            return this.adjust(metadata, metadata.getWidth() * o.getWidthFactor(), metadata.getHeight() * o.getHeightFactor());
        }
        if (operation instanceof ImageCropOperation) {
            ImageCropOperation o = (ImageCropOperation)operation;
            float width = IImageMetadataAdjustor.adjust(metadata.getWidth(), o.getX(), o.getWidth());
            float height = IImageMetadataAdjustor.adjust(metadata.getHeight(), o.getY(), o.getHeight());
            return this.adjust(metadata, width, height);
        }
        if (operation instanceof ImageMapBandsOperation) {
            ImageMapBandsOperation o = (ImageMapBandsOperation)operation;
            return this.adjust(metadata, o.getMappingSize(), o.getMappingSize(), o.getMappingSize() < 3 ? 6 : 5);
        }
        if (operation instanceof ImageOpacityOperation) {
            ImageOpacityOperation o = (ImageOpacityOperation)operation;
            if (o.getFactor() >= 1.0f) {
                return metadata;
            }
            return this.adjust(metadata, 4, 4, 5);
        }
        if (operation instanceof ImageInvertOperation) {
            return metadata;
        }
        if (operation instanceof ImageToGrayScaleOperation) {
            int numberOfComponents = this.adjustToGrayScale(metadata.getNumberOfColorComponents());
            int numberOfBands = this.adjustToGrayScale(metadata.getNumberOfBands());
            return this.adjust(metadata, numberOfComponents, numberOfBands, 6);
        }
        return metadata;
    }

    default public int adjustToGrayScale(int compoments) {
        if (compoments == 4) {
            return 2;
        }
        if (compoments >= 3) {
            return 1;
        }
        return compoments;
    }

    public static float adjust(float currentValue, float offset, float value) {
        return offset >= 0.0f ? (offset > currentValue ? 0.0f : (offset + value <= currentValue ? value : currentValue - offset)) : (offset + value < 0.0f ? 0.0f : (offset + value <= currentValue ? offset + value : currentValue));
    }

    default public IImageMetadata adjust(IImageMetadata metadata, float width, float height) {
        if (metadata == null || metadata instanceof InvalidImageMetadata) {
            return metadata;
        }
        if (metadata.getWidth() <= 0.0f) {
            return new InvalidImageMetadata(new MessageBuilder().setText("width <= 0").setError().build());
        }
        if (metadata.getHeight() <= 0.0f) {
            return new InvalidImageMetadata(new MessageBuilder().setText("height <= 0").setError().build());
        }
        return this.doAdjust(metadata, width, height);
    }

    default public IImageMetadata adjust(IImageMetadata metadata, int numberOfComponents, int numberOfBands, int colorSpaceType) {
        if (metadata == null || metadata instanceof InvalidImageMetadata) {
            return metadata;
        }
        if (metadata.getNumberOfBands() <= 0) {
            return new InvalidImageMetadata(new MessageBuilder().setText("number of bands <= 0").setError().build());
        }
        if (metadata.getNumberOfColorComponents() <= 0) {
            return new InvalidImageMetadata(new MessageBuilder().setText("number of components <= 0").setError().build());
        }
        if (metadata.getColorSpaceType() < 0 || metadata.getColorSpaceType() > 25) {
            return new InvalidImageMetadata(new MessageBuilder().setText("number of components <= 0").setError().build());
        }
        return this.doAdjust(metadata, numberOfComponents, numberOfBands, colorSpaceType);
    }

    default public IImageMetadata copy(IImageMetadata metadata) {
        if (metadata == null || metadata instanceof InvalidImageMetadata) {
            return metadata;
        }
        return this.doCopy(metadata);
    }

    default public IImageMetadata adjust(IImageMetadata metadata, int numberOfComponents, int numberOfBands, int colorSpaceType, int dataType, int transparency) {
        if (metadata == null || metadata instanceof InvalidImageMetadata) {
            return metadata;
        }
        return this.doAdjust(metadata, numberOfComponents, numberOfBands, colorSpaceType, dataType, transparency);
    }

    public IImageMetadata doAdjust(IImageMetadata var1, int var2, int var3, int var4, int var5, int var6);

    public IImageMetadata doAdjust(IImageMetadata var1, float var2, float var3);

    public IImageMetadata doAdjust(IImageMetadata var1, int var2, int var3, int var4);

    public IImageMetadata doCopy(IImageMetadata var1);
}

