/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageContainerFactory;
import net.anwiba.commons.image.apache.ApacheImageContainerFactory;
import net.anwiba.commons.image.awt.BufferedImageContainerFactory;
import net.anwiba.commons.image.imageio.IImageInputStreamConnector;
import net.anwiba.commons.image.imageio.ImageIoImageContainerFactory;
import net.anwiba.commons.image.imageio.SeekableImageInputStream;
import net.anwiba.commons.image.imagen.ISeekableStreamConnector;
import net.anwiba.commons.image.imagen.ImagenImageContainerFactory;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import org.eclipse.imagen.media.codec.SeekableStream;

public class ImageContainerFactory
implements IImageContainerFactory {
    private static ILogger logger = Logging.getLogger(ImageContainerFactory.class);
    final ImagenImageContainerFactory imagenImageContainerFactory;
    final ImageIoImageContainerFactory imageIoImageContainerFactory;
    final BufferedImageContainerFactory bufferedImageContainerFactory;
    private final ApacheImageContainerFactory apacheImageContainerFactory;

    public static ImageContainerFactory of(RenderingHints hints, IResourceReferenceHandler resourceReferenceHandler) {
        RenderingHints renderingHints = (RenderingHints)Optional.of((Object)hints).getOr(() -> new RenderingHints(Map.of()));
        return new ImageContainerFactory(new BufferedImageContainerFactory(renderingHints), new ApacheImageContainerFactory(renderingHints, resourceReferenceHandler), new ImageIoImageContainerFactory(renderingHints, resourceReferenceHandler), new ImagenImageContainerFactory(renderingHints, resourceReferenceHandler));
    }

    public ImageContainerFactory(BufferedImageContainerFactory bufferedImageContainerFactory, ApacheImageContainerFactory apacheImageContainerFactory, ImageIoImageContainerFactory imageIoImageContainerFactory, ImagenImageContainerFactory imagenImageContainerFactory) {
        this.bufferedImageContainerFactory = bufferedImageContainerFactory;
        this.apacheImageContainerFactory = apacheImageContainerFactory;
        this.imageIoImageContainerFactory = imageIoImageContainerFactory;
        this.imagenImageContainerFactory = imagenImageContainerFactory;
    }

    @Override
    public IImageContainer create(BufferedImage image) {
        return this.bufferedImageContainerFactory.create(image);
    }

    @Override
    public IImageContainer create(IResourceReference resourceReference) throws IOException {
        ISeekableStreamConnector connector = this.imagenImageContainerFactory.createInputStreamConnector(resourceReference);
        try (SeekableStream seekableStream = connector.connect();){
            if (this.imagenImageContainerFactory.isSupported(seekableStream)) {
                seekableStream.seek(0L);
                IImageContainer iImageContainer = this.imagenImageContainerFactory.create(connector);
                return iImageContainer;
            }
            seekableStream.seek(0L);
            IImageInputStreamConnector imageInputStreamConnector = () -> {
                seekableStream.seek(0L);
                return new SeekableImageInputStream(seekableStream);
            };
            if (this.imageIoImageContainerFactory.isSupported(imageInputStreamConnector)) {
                IImageContainer iImageContainer = this.imageIoImageContainerFactory.create(resourceReference);
                return iImageContainer;
            }
            seekableStream.seek(0L);
            if (this.apacheImageContainerFactory.isSupported((InputStream)seekableStream)) {
                IImageContainer iImageContainer = this.apacheImageContainerFactory.create(resourceReference);
                return iImageContainer;
            }
        }
        throw new IOException("Unsupported image format");
    }
}

