/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.io.IOException;
import net.anwiba.commons.image.IImageDirectory;
import net.anwiba.commons.image.IImageDirectoryReader;
import net.anwiba.commons.image.apache.ApacheImageDirectoryReader;
import net.anwiba.commons.image.imagen.ISeekableStreamConnector;
import net.anwiba.commons.image.imagen.ImagenImageDirectoryReader;
import net.anwiba.commons.image.imagen.InputStreamConnectorFactory;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.eclipse.imagen.media.codec.SeekableStream;

public class ImageDirectoryReader
implements IImageDirectoryReader {
    private final InputStreamConnectorFactory inputStreamConnectorFactory;
    private final ImagenImageDirectoryReader imagenImageDirectoryReader;
    private final ApacheImageDirectoryReader apacheImageDirectoryReader;

    public ImageDirectoryReader(IResourceReferenceHandler resourceReferenceHandler) {
        this.imagenImageDirectoryReader = new ImagenImageDirectoryReader(resourceReferenceHandler);
        this.inputStreamConnectorFactory = new InputStreamConnectorFactory(resourceReferenceHandler);
        this.apacheImageDirectoryReader = new ApacheImageDirectoryReader(resourceReferenceHandler);
    }

    @Override
    public IImageDirectory read(ICanceler canceler, IResourceReference resourceReference) throws CanceledException, IOException {
        if (this.apacheImageDirectoryReader.isSupported(resourceReference)) {
            return this.apacheImageDirectoryReader.read(canceler, resourceReference);
        }
        ISeekableStreamConnector connector = this.inputStreamConnectorFactory.create(resourceReference);
        try (SeekableStream seekableStream = connector.connect();){
            if (this.imagenImageDirectoryReader.isSupported(seekableStream)) {
                seekableStream.seek(0L);
                IImageDirectory iImageDirectory = this.imagenImageDirectoryReader.read(canceler, resourceReference);
                return iImageDirectory;
            }
        }
        return new IImageDirectory(){};
    }
}

