/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageContainerFactory;
import net.anwiba.commons.image.IImageReader;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.thread.cancel.ICanceler;

public final class ImageReader
implements IImageReader {
    private static ILogger logger = Logging.getLogger(ImageReader.class);
    private final IImageContainerFactory imageContainerFactory;

    public ImageReader(IImageContainerFactory imageContainerFactory) {
        this.imageContainerFactory = imageContainerFactory;
    }

    @Override
    public IImageContainer read(ICanceler canceler, IResourceReference resourceReference) throws CanceledException, IOException {
        canceler.check();
        return this.imageContainerFactory.create(resourceReference);
    }

    @Override
    public IImageContainer read(ICanceler canceler, InputStream inputStream) throws CanceledException, IOException {
        canceler.check();
        return this.imageContainerFactory.create(inputStream);
    }

    @Override
    public IImageContainer read(ICanceler canceler, File file) throws CanceledException, IOException {
        canceler.check();
        return this.imageContainerFactory.create(file);
    }
}

