/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.apache;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.apache.ApacheImageContainer;
import net.anwiba.commons.image.apache.ApacheImageMetadataAdjustor;
import net.anwiba.commons.image.apache.ByteSourceConnectorFactory;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceInputStream;

public class ApacheImageContainerFactory {
    private final IImageMetadataAdjustor metadataAdjustor = new ApacheImageMetadataAdjustor();
    private final RenderingHints hints;
    private final ByteSourceConnectorFactory byteSourceConnectorFactory;

    public ApacheImageContainerFactory(RenderingHints hints, IResourceReferenceHandler resourceReferenceHandler) {
        this.byteSourceConnectorFactory = new ByteSourceConnectorFactory(resourceReferenceHandler);
        this.hints = hints;
    }

    public IImageContainer create(IResourceReference resourceReference) {
        return new ApacheImageContainer(this.hints, null, this.byteSourceConnectorFactory.create(resourceReference), this.metadataAdjustor);
    }

    public boolean isSupported(InputStream inputStream) {
        try {
            ImageFormat format = Imaging.guessFormat((ByteSource)new ByteSourceInputStream(inputStream, "foo"));
            if (!format.equals(ImageFormats.UNKNOWN)) {
                ImageParser[] imageParsers;
                for (ImageParser imageParser : imageParsers = ImageParser.getAllImageParsers()) {
                    if (!imageParser.canAcceptType(format)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IOException | ImageReadException exception) {
            return false;
        }
    }
}

