/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.apache;

import java.io.IOException;
import java.net.URISyntaxException;
import net.anwiba.commons.image.apache.IByteSourceConnector;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.UriResourceReference;
import net.anwiba.commons.reference.UrlResourceReference;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.io.url.UrlBuilder;
import net.anwiba.commons.utilities.io.url.parser.UrlParser;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceArray;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.common.bytesource.ByteSourceInputStream;

public class ByteSourceConnectorFactory {
    private final IResourceReferenceHandler resourceReferenceHandler;

    public ByteSourceConnectorFactory(IResourceReferenceHandler resourceReferenceHandler) {
        this.resourceReferenceHandler = resourceReferenceHandler;
    }

    public IByteSourceConnector create(IResourceReference reference) {
        return () -> this.connect(reference);
    }

    private ByteSource connect(IResourceReference resourceReference) throws IOException {
        try {
            return (ByteSource)resourceReference.accept((IResourceReferenceVisitor)new IResourceReferenceVisitor<ByteSource, IOException>(){

                public ByteSource visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                    return new ByteSourceFile(fileResourceReference.getFile());
                }

                public ByteSource visitUrlResource(UrlResourceReference urlResourceReference) throws IOException {
                    if (ByteSourceConnectorFactory.this.resourceReferenceHandler.isFileSystemResource((IResourceReference)urlResourceReference)) {
                        return ByteSourceConnectorFactory.this.openAsFileIfPossible((IResourceReference)urlResourceReference);
                    }
                    return new ByteSourceInputStream(ByteSourceConnectorFactory.this.resourceReferenceHandler.openInputStream((IResourceReference)urlResourceReference), ByteSourceConnectorFactory.this.resourceReferenceHandler.getFileName((IResourceReference)urlResourceReference));
                }

                public ByteSource visitUriResource(UriResourceReference uriResourceReference) throws IOException {
                    if (ByteSourceConnectorFactory.this.resourceReferenceHandler.isFileSystemResource((IResourceReference)uriResourceReference)) {
                        return ByteSourceConnectorFactory.this.openAsFileIfPossible((IResourceReference)uriResourceReference);
                    }
                    return new ByteSourceInputStream(ByteSourceConnectorFactory.this.resourceReferenceHandler.openInputStream((IResourceReference)uriResourceReference), ByteSourceConnectorFactory.this.resourceReferenceHandler.getFileName((IResourceReference)uriResourceReference));
                }

                public ByteSource visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                    return new ByteSourceArray(memoryResourceReference.getBuffer());
                }

                public ByteSource visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                    return this.visitFileResource(new FileResourceReference(pathResourceReference.getPath().toFile()));
                }
            });
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed reading the provided resource reference: %s", this.toPrintableString(resourceReference)), e);
        }
    }

    private ByteSource openAsFileIfPossible(IResourceReference reference) throws IOException {
        try {
            return new ByteSourceFile(this.resourceReferenceHandler.getFile(reference));
        }
        catch (URISyntaxException e) {
            return new ByteSourceInputStream(this.resourceReferenceHandler.openInputStream(reference), this.resourceReferenceHandler.getFileName(reference));
        }
    }

    private String toPrintableString(IResourceReference resourceReference) {
        String string = this.resourceReferenceHandler.toString(resourceReference);
        try {
            IUrl url = new UrlParser().parse(string);
            if (url.getPassword() != null) {
                return new UrlBuilder(url).setPassword("**********").build().toString();
            }
            return new UrlBuilder(url).build().toString();
        }
        catch (CreationException exception) {
            return string;
        }
    }
}

