/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.awt;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import net.anwiba.commons.image.AbstractImageContainer;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.awt.BufferedImageMetadata;
import net.anwiba.commons.image.awt.BufferedImageMetadataFactory;
import net.anwiba.commons.image.awt.BufferedImageOperatorFactory;
import net.anwiba.commons.image.awt.IBufferedImageOperator;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;

class BufferedImageContainer
extends AbstractImageContainer {
    private static ILogger logger = Logging.getLogger(BufferedImageContainer.class);
    private final BufferedImage image;

    public BufferedImageContainer(RenderingHints hints, BufferedImageMetadata metadata, BufferedImage image, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        super(hints, metadata, operations, metadataAdjustor);
        this.image = image;
    }

    @Override
    public int getWidth() {
        return (int)Math.ceil(this.getMetadata().getWidth());
    }

    @Override
    public int getHeight() {
        return (int)Math.ceil(this.getMetadata().getHeight());
    }

    @Override
    public void dispose() {
    }

    @Override
    protected IImageMetadata read(ICanceler canceler, RenderingHints hints) throws CanceledException, IOException {
        return new BufferedImageMetadata(this.image.getWidth(), this.image.getHeight(), this.image.getColorModel().getNumColorComponents(), this.image.getColorModel().getNumComponents(), this.image.getColorModel().getColorSpace().getType(), this.image.getColorModel().getTransferType(), this.image.getColorModel().getTransparency(), this.image.getColorModel() instanceof IndexColorModel);
    }

    @Override
    protected BufferedImage read(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) throws CanceledException, IOException {
        long size = (long)this.getWidth() * (long)this.getHeight();
        if (size >= Integer.MAX_VALUE) {
            logger.log(ILevel.WARNING, "image dimensions (width=" + this.getWidth() + " height=" + this.getHeight() + ") are too large");
            return null;
        }
        canceler.check();
        IBufferedImageOperator bufferedImageOperator = new BufferedImageOperatorFactory(metadataAdjustor).create(new BufferedImageMetadataFactory().create(this.image), operations, hints);
        return bufferedImageOperator.execute(canceler, this.image);
    }

    @Override
    protected IImageContainer adapt(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        BufferedImageMetadata imageMetadata = (BufferedImageMetadata)metadata;
        return new BufferedImageContainer(hints, imageMetadata, this.image, operations, metadataAdjustor);
    }
}

