/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imageio;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import net.anwiba.commons.image.AbstractImageContainer;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageContainerSettings;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.imageio.IImageInputStreamConnector;
import net.anwiba.commons.image.imageio.IImageIoImageContainerSettings;
import net.anwiba.commons.image.imageio.ImageIoImageMetadata;
import net.anwiba.commons.image.imagen.ImagenImageMetadataAdjustor;
import net.anwiba.commons.image.imagen.RenderedImageContainer;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageCropOperation;
import net.anwiba.commons.image.operation.ImageMapBandsOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.thread.cancel.ICanceler;

class ImageIoImageContainer
extends AbstractImageContainer {
    private static ILogger logger = Logging.getLogger(ImageIoImageContainer.class);
    private final IImageInputStreamConnector imageInputStreamConnector;

    public ImageIoImageContainer(RenderingHints hints, IImageMetadata metadata, IImageInputStreamConnector imageInputStream, IImageMetadataAdjustor metadataAdjustor) {
        this(hints, metadata, imageInputStream, (IObjectList<IImageOperation>)new ObjectList(), metadataAdjustor);
    }

    private ImageIoImageContainer(RenderingHints hints, IImageMetadata metadata, IImageInputStreamConnector imageInputStream, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        super(hints, metadata, operations, metadataAdjustor);
        this.imageInputStreamConnector = imageInputStream;
    }

    @Override
    protected IImageContainer adapt(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        return new ImageIoImageContainer(hints, metadata, this.imageInputStreamConnector, operations, metadataAdjustor);
    }

    @Override
    protected ImageIoImageMetadata read(ICanceler canceler, RenderingHints hints) throws CanceledException, IOException {
        ImageReader imageReader = null;
        try {
            ImageIoImageMetadata imageIoImageMetadata;
            block10: {
                ImageInputStream inputStream = this.imageInputStreamConnector.connect();
                try {
                    imageReader = this.getImageReader(inputStream, hints);
                    imageIoImageMetadata = this.read(canceler, imageReader);
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return imageIoImageMetadata;
        }
        finally {
            if (imageReader == null) {
                return null;
            }
            imageReader.setInput(null);
            imageReader.dispose();
        }
    }

    private ImageReader getImageReader(ImageInputStream inputStream, RenderingHints hints) throws IOException {
        IImageIoImageContainerSettings imageIoSettings = IImageIoImageContainerSettings.getSettings(hints);
        IImageContainerSettings settings = IImageContainerSettings.getSettings(hints);
        IObjectList imageReaders = Streams.of(IOException.class, ImageIO.getImageReaders(inputStream)).asObjectList();
        if (imageReaders.isEmpty()) {
            logger.log(ILevel.WARNING, "missing reader", (Throwable)new IOException("missing reader"));
            settings.getImageContainerListener().eventOccurred("missing imageio reader", null, MessageType.WARNING);
            return null;
        }
        ImageReader imageReader = imageIoSettings.getImageReader((IObjectList<ImageReader>)imageReaders);
        imageReader.setInput(inputStream);
        return imageReader;
    }

    private ImageIoImageMetadata read(ICanceler canceler, ImageReader imageReader) throws IOException {
        int index = imageReader.getMinIndex();
        int width = imageReader.getWidth(index);
        int height = imageReader.getHeight(index);
        ImageTypeSpecifier imageType = (ImageTypeSpecifier)Streams.of(IOException.class, imageReader.getImageTypes(index)).first().get();
        ColorModel colorModel = imageType.getColorModel();
        int numColorComponents = colorModel.getNumColorComponents();
        int numBands = colorModel.getNumComponents();
        ImageIoImageMetadata metadata = new ImageIoImageMetadata(index, width, height, numColorComponents, numBands, colorModel.getColorSpace().getType(), colorModel.getTransferType(), colorModel.getTransparency(), imageType, colorModel instanceof IndexColorModel);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected BufferedImage read(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> imageOperations, IImageMetadataAdjustor metadataAdjustor) throws CanceledException, IOException {
        IImageContainerSettings settings = IImageContainerSettings.getSettings(hints);
        try (ImageInputStream inputStream = this.imageInputStreamConnector.connect();){
            long size = (long)this.getWidth() * (long)this.getHeight();
            if (size >= Integer.MAX_VALUE) {
                logger.log(ILevel.WARNING, "image dimensions (width=" + this.getWidth() + " height=" + this.getHeight() + ") are too large");
                BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                return bufferedImage;
            }
            inputStream.seek(0L);
            canceler.check();
            ImageReader imageReader = this.getImageReader(inputStream, hints);
            if (imageReader == null) {
                BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                return bufferedImage;
            }
            canceler.check();
            imageReader.addIIOReadWarningListener((source, warning) -> settings.getImageContainerListener().eventOccurred(warning, null, MessageType.WARNING));
            ImageIoImageMetadata metadata = this.read(canceler, imageReader);
            if (metadata == null) {
                BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), this.getColorSpaceType());
                return bufferedImage;
            }
            IOptional<ImageCropOperation, RuntimeException> cropOperation = ImageCropOperation.aggregate(imageOperations);
            ImageReadParam imageReadParameter = imageReader.getDefaultReadParam();
            ObjectList operations = new ObjectList();
            for (Object operation : imageOperations) {
                if (operation instanceof ImageCropOperation) continue;
                if (operation instanceof ImageMapBandsOperation) {
                    ImageMapBandsOperation o = (ImageMapBandsOperation)operation;
                    if (o.getMappingSize() == metadata.getNumberOfBands() && !o.isIdentity() && !o.hasDuplicate()) {
                        imageReadParameter.setSourceBands(o.getBandMapping());
                        continue;
                    }
                    if (o.getMappingSize() == metadata.getNumberOfBands() && o.isIdentity()) continue;
                    operations.add((Object[])new IImageOperation[]{operation});
                    continue;
                }
                operations.add((Object[])new IImageOperation[]{operation});
            }
            inputStream.seek(0L);
            if (cropOperation.isAccepted()) {
                imageReadParameter.setSourceRegion(((ImageCropOperation)cropOperation.get()).getBounds());
            }
            canceler.check();
            BufferedImage image = imageReader.read(metadata.getIndex(), imageReadParameter);
            if (operations.isEmpty()) {
                Object operation;
                operation = image;
                return operation;
            }
            canceler.check();
            IImageContainer bufferedImageContainer = new RenderedImageContainer(hints, image, new ImagenImageMetadataAdjustor());
            try {
                for (IImageOperation operation : operations) {
                    bufferedImageContainer = bufferedImageContainer.operation(operation);
                }
                Object object = bufferedImageContainer.asBufferImage(canceler);
                imageReader.setInput(null);
                imageReader.dispose();
                bufferedImageContainer.dispose();
                return object;
            }
            catch (Throwable throwable) {
                imageReader.setInput(null);
                imageReader.dispose();
                bufferedImageContainer.dispose();
                throw throwable;
            }
        }
        catch (IOException | RuntimeException exception) {
            logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
            settings.getImageContainerListener().eventOccurred(exception.getMessage(), exception, MessageType.ERROR);
            return null;
        }
    }
}

