/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imageio;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import net.anwiba.commons.image.IImageMetaDataReader;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.ImageMetadata;
import net.anwiba.commons.image.InvalidImageMetadata;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.MessageBuilder;

public class ImageIoImageMetaDataReader
implements IImageMetaDataReader {
    private static ILogger logger = Logging.getLogger(ImageIoImageMetaDataReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImageMetadata read(InputStream inputStream) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        IObjectList imageReaders = Streams.of(IOException.class, ImageIO.getImageReaders(imageInputStream)).asObjectList();
        if (imageReaders.isEmpty()) {
            imageInputStream.close();
            logger.log(ILevel.WARNING, "missing reader");
            IOException exception = new IOException("missing reader");
            logger.log(ILevel.DEBUG, "missing reader", (Throwable)exception);
            return new InvalidImageMetadata(new MessageBuilder().setError().setText(exception.getMessage()).setThrowable((Throwable)exception).build());
        }
        ImageReader imageReader = null;
        try {
            ImageMetadata metadata;
            imageReader = (ImageReader)imageReaders.stream().first().get();
            imageReader.setInput(imageInputStream);
            int index = imageReader.getMinIndex();
            int width = imageReader.getWidth(index);
            int height = imageReader.getHeight(index);
            ImageTypeSpecifier imageType = (ImageTypeSpecifier)Streams.of(IOException.class, imageReader.getImageTypes(index)).first().get();
            ColorModel colorModel = imageType.getColorModel();
            int numColorComponents = colorModel.getNumColorComponents();
            int numBands = colorModel.getNumComponents();
            ImageMetadata imageMetadata = metadata = new ImageMetadata(width, height, numColorComponents, numBands, colorModel.getColorSpace().getType(), colorModel.getTransferType(), colorModel.getTransparency(), colorModel instanceof IndexColorModel);
            return imageMetadata;
        }
        finally {
            imageReader.setInput(null);
            imageReader.dispose();
        }
    }

    public boolean isSupported(InputStream inputStream) {
        ImageInputStream imageInputStream = null;
        try {
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            IObjectList imageReaders = Streams.of(IOException.class, ImageIO.getImageReaders(imageInputStream)).asObjectList();
            imageInputStream.close();
            return !imageReaders.isEmpty();
        }
        catch (IOException exception) {
            Optional.of(IOException.class, (Object)imageInputStream).consume(s -> s.close());
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            return false;
        }
    }
}

