/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imageio;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.Stack;
import javax.imageio.IIOException;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.imagen.media.codec.SeekableStream;

public class SeekableImageInputStream
implements ImageInputStream {
    private static final int BYTE_BUF_LENGTH = 8192;
    byte[] byteBuf = new byte[8192];
    private final Stack<Long> markByteStack = new Stack();
    private final Stack<Integer> markBitStack = new Stack();
    private SeekableStream seekableStream;
    private boolean isClosed = false;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private int bitOffset = 0;
    private long flushedPos = 0L;

    public SeekableImageInputStream(SeekableStream seekableStream) {
        this.seekableStream = seekableStream;
    }

    protected final void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        return this.seekableStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        return this.seekableStream.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.seekableStream = null;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkClosed();
        return this.seekableStream.read(b);
    }

    @Override
    public void readBytes(IIOByteBuffer buf, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("len < 0!");
        }
        if (buf == null) {
            throw new NullPointerException("buf == null!");
        }
        byte[] data = new byte[len];
        len = this.read(data, 0, len);
        buf.setData(data);
        buf.setOffset(0);
        buf.setLength(len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkClosed();
        return this.seekableStream.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.checkClosed();
        return this.seekableStream.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkClosed();
        return this.seekableStream.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.checkClosed();
        if (Objects.equals(this.byteOrder, ByteOrder.LITTLE_ENDIAN)) {
            return this.seekableStream.readShortLE();
        }
        return this.seekableStream.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.checkClosed();
        if (Objects.equals(this.byteOrder, ByteOrder.LITTLE_ENDIAN)) {
            return this.seekableStream.readUnsignedShortLE();
        }
        return this.seekableStream.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.checkClosed();
        if (Objects.equals(this.byteOrder, ByteOrder.LITTLE_ENDIAN)) {
            return this.seekableStream.readCharLE();
        }
        return this.seekableStream.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.checkClosed();
        if (Objects.equals(this.byteOrder, ByteOrder.LITTLE_ENDIAN)) {
            return this.seekableStream.readIntLE();
        }
        return this.seekableStream.readInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        this.checkClosed();
        if (Objects.equals(this.byteOrder, ByteOrder.LITTLE_ENDIAN)) {
            return this.seekableStream.readUnsignedIntLE();
        }
        return this.seekableStream.readUnsignedInt();
    }

    @Override
    public long readLong() throws IOException {
        this.checkClosed();
        if (Objects.equals(this.byteOrder, ByteOrder.LITTLE_ENDIAN)) {
            return this.seekableStream.readLongLE();
        }
        return this.seekableStream.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.checkClosed();
        if (Objects.equals(this.byteOrder, ByteOrder.LITTLE_ENDIAN)) {
            return this.seekableStream.readFloatLE();
        }
        return this.seekableStream.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.checkClosed();
        if (Objects.equals(this.byteOrder, ByteOrder.LITTLE_ENDIAN)) {
            return this.seekableStream.readDoubleLE();
        }
        return this.seekableStream.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        this.checkClosed();
        return this.seekableStream.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        this.checkClosed();
        return this.seekableStream.readUTF();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        while (len > 0) {
            int nbytes = this.read(b, off, len);
            if (nbytes == -1) {
                throw new EOFException();
            }
            off += nbytes;
            len -= nbytes;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, nelts * 2);
            this.toShorts(this.byteBuf, s, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    @Override
    public void readFully(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, nelts * 2);
            this.toChars(this.byteBuf, c, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    @Override
    public void readFully(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, nelts * 4);
            this.toInts(this.byteBuf, i, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    @Override
    public void readFully(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, nelts * 8);
            this.toLongs(this.byteBuf, l, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    @Override
    public void readFully(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, nelts * 4);
            this.toFloats(this.byteBuf, f, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    @Override
    public void readFully(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        while (len > 0) {
            int nelts = Math.min(len, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, nelts * 8);
            this.toDoubles(this.byteBuf, d, off, nelts);
            off += nelts;
            len -= nelts;
        }
    }

    private void toShorts(byte[] b, short[] s, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                s[off + j] = (short)(b0 << 8 | b1);
                boff += 2;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 1];
                int b1 = b[boff] & 0xFF;
                s[off + j] = (short)(b0 << 8 | b1);
                boff += 2;
            }
        }
    }

    private void toChars(byte[] b, char[] c, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                c[off + j] = (char)(b0 << 8 | b1);
                boff += 2;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 1];
                int b1 = b[boff] & 0xFF;
                c[off + j] = (char)(b0 << 8 | b1);
                boff += 2;
            }
        }
    }

    private void toInts(byte[] b, int[] i, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                int b2 = b[boff + 2] & 0xFF;
                int b3 = b[boff + 3] & 0xFF;
                i[off + j] = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                boff += 4;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 3];
                int b1 = b[boff + 2] & 0xFF;
                int b2 = b[boff + 1] & 0xFF;
                int b3 = b[boff] & 0xFF;
                i[off + j] = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                boff += 4;
            }
        }
    }

    private void toLongs(byte[] b, long[] l, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                int b2 = b[boff + 2] & 0xFF;
                int b3 = b[boff + 3] & 0xFF;
                byte b4 = b[boff + 4];
                int b5 = b[boff + 5] & 0xFF;
                int b6 = b[boff + 6] & 0xFF;
                int b7 = b[boff + 7] & 0xFF;
                int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
                l[off + j] = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
                boff += 8;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 7];
                int b1 = b[boff + 6] & 0xFF;
                int b2 = b[boff + 5] & 0xFF;
                int b3 = b[boff + 4] & 0xFF;
                byte b4 = b[boff + 3];
                int b5 = b[boff + 2] & 0xFF;
                int b6 = b[boff + 1] & 0xFF;
                int b7 = b[boff] & 0xFF;
                int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
                l[off + j] = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
                boff += 8;
            }
        }
    }

    private void toFloats(byte[] b, float[] f, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                int b2 = b[boff + 2] & 0xFF;
                int b3 = b[boff + 3] & 0xFF;
                int i = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                f[off + j] = Float.intBitsToFloat(i);
                boff += 4;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 3];
                int b1 = b[boff + 2] & 0xFF;
                int b2 = b[boff + 1] & 0xFF;
                int b3 = b[boff + 0] & 0xFF;
                int i = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                f[off + j] = Float.intBitsToFloat(i);
                boff += 4;
            }
        }
    }

    private void toDoubles(byte[] b, double[] d, int off, int len) {
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                int b2 = b[boff + 2] & 0xFF;
                int b3 = b[boff + 3] & 0xFF;
                byte b4 = b[boff + 4];
                int b5 = b[boff + 5] & 0xFF;
                int b6 = b[boff + 6] & 0xFF;
                int b7 = b[boff + 7] & 0xFF;
                int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
                long l = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
                d[off + j] = Double.longBitsToDouble(l);
                boff += 8;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 7];
                int b1 = b[boff + 6] & 0xFF;
                int b2 = b[boff + 5] & 0xFF;
                int b3 = b[boff + 4] & 0xFF;
                byte b4 = b[boff + 3];
                int b5 = b[boff + 2] & 0xFF;
                int b6 = b[boff + 1] & 0xFF;
                int b7 = b[boff] & 0xFF;
                int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
                int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
                long l = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
                d[off + j] = Double.longBitsToDouble(l);
                boff += 8;
            }
        }
    }

    @Override
    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.seekableStream.getFilePointer();
    }

    @Override
    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    @Override
    public void setBitOffset(int bitOffset) throws IOException {
        this.checkClosed();
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("bitOffset must be betwwen 0 and 7!");
        }
        this.bitOffset = bitOffset;
    }

    @Override
    public int readBit() throws IOException {
        this.checkClosed();
        int newBitOffset = this.bitOffset + 1 & 7;
        int val = this.read();
        if (val == -1) {
            throw new EOFException();
        }
        if (newBitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
            val >>= 8 - newBitOffset;
        }
        this.bitOffset = newBitOffset;
        return val & 1;
    }

    @Override
    public long readBits(int numBits) throws IOException {
        int bitsToRead;
        this.checkClosed();
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numBits == 0) {
            return 0L;
        }
        int newBitOffset = this.bitOffset + numBits & 7;
        long accum = 0L;
        for (bitsToRead = numBits + this.bitOffset; bitsToRead > 0; bitsToRead -= 8) {
            int val = this.read();
            if (val == -1) {
                throw new EOFException();
            }
            accum <<= 8;
            accum |= (long)val;
        }
        if (newBitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
        }
        this.bitOffset = newBitOffset;
        accum >>>= -bitsToRead;
        return accum &= -1L >>> 64 - numBits;
    }

    @Override
    public long length() throws IOException {
        return -1L;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.checkClosed();
        int skipBytes = this.seekableStream.skipBytes(n);
        this.bitOffset = 0;
        return skipBytes;
    }

    @Override
    public long skipBytes(long n) throws IOException {
        this.checkClosed();
        long skipBytes = this.seekableStream.skip(n);
        this.bitOffset = 0;
        return skipBytes;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkClosed();
        this.seekableStream.seek(pos);
        this.bitOffset = 0;
    }

    @Override
    public void mark() {
        try {
            this.markByteStack.push(this.getStreamPosition());
            this.markBitStack.push(this.getBitOffset());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.markByteStack.empty()) {
            return;
        }
        long pos = this.markByteStack.pop();
        if (pos < this.flushedPos) {
            throw new IIOException("Previous marked position has been discarded!");
        }
        this.seek(pos);
        int offset = this.markBitStack.pop();
        this.setBitOffset(offset);
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        if (pos > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("pos > getStreamPosition()!");
        }
        this.flushedPos = pos;
    }

    @Override
    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    @Override
    public long getFlushedPosition() {
        return this.flushedPos;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }
}

