/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import net.anwiba.commons.image.AbstractImageContainer;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.imagen.ISeekableStreamConnector;
import net.anwiba.commons.image.imagen.ImagenImageMetadata;
import net.anwiba.commons.image.imagen.PlanarImageOperatorFactory;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.codec.SeekableStream;
import org.eclipse.imagen.operator.StreamDescriptor;

class ImagenImageContainer
extends AbstractImageContainer {
    private final ISeekableStreamConnector seekableStreamConnector;

    public ImagenImageContainer(RenderingHints hints, IImageMetadata metadata, ISeekableStreamConnector seekableStreamConnector, IImageMetadataAdjustor metadataAdjustor) {
        this(hints, metadata, (IObjectList<IImageOperation>)new ObjectList(), seekableStreamConnector, metadataAdjustor);
    }

    public ImagenImageContainer(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, ISeekableStreamConnector seekableStreamConnector, IImageMetadataAdjustor metadataAdjustor) {
        super(hints, metadata, operations, metadataAdjustor);
        this.seekableStreamConnector = seekableStreamConnector;
    }

    @Override
    protected IImageMetadata read(ICanceler canceler, RenderingHints hints) throws CanceledException, IOException {
        RenderedOp renderedOp = null;
        try {
            ImagenImageMetadata imagenImageMetadata;
            block10: {
                SeekableStream inputStream = this.seekableStreamConnector.connect();
                try {
                    renderedOp = StreamDescriptor.create((SeekableStream)inputStream, null, (RenderingHints)hints);
                    ColorModel colorModel = renderedOp.getColorModel();
                    imagenImageMetadata = new ImagenImageMetadata(renderedOp.getWidth(), renderedOp.getHeight(), colorModel.getNumColorComponents(), colorModel.getNumComponents(), colorModel.getColorSpace().getType(), colorModel.getTransferType(), colorModel.getTransparency(), colorModel instanceof IndexColorModel);
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return imagenImageMetadata;
        }
        finally {
            if (renderedOp != null) {
                renderedOp.dispose();
            }
        }
    }

    @Override
    protected IImageContainer adapt(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        return new ImagenImageContainer(hints, metadata, operations, this.seekableStreamConnector, metadataAdjustor);
    }

    @Override
    protected BufferedImage read(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> imageOperations, IImageMetadataAdjustor metadataAdjustor) throws CanceledException, IOException {
        IImageMetadata metadata = this.read(canceler, hints);
        PlanarImage planarImage = null;
        try {
            BufferedImage bufferedImage;
            block10: {
                SeekableStream inputStream = this.seekableStreamConnector.connect();
                try {
                    RenderedOp renderedOp = StreamDescriptor.create((SeekableStream)inputStream, null, (RenderingHints)hints);
                    planarImage = new PlanarImageOperatorFactory(metadataAdjustor).create((ImagenImageMetadata)metadata, imageOperations, hints).execute(canceler, (PlanarImage)renderedOp);
                    BufferedImage bufferedImage2 = bufferedImage = planarImage == null ? null : planarImage.getAsBufferedImage();
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return bufferedImage;
        }
        finally {
            if (planarImage != null) {
                planarImage.dispose();
            }
        }
    }
}

