/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import java.io.IOException;
import java.util.Set;
import net.anwiba.commons.image.IImageDirectory;
import net.anwiba.commons.image.imagen.ISeekableStreamConnector;
import net.anwiba.commons.image.imagen.InputStreamConnectorFactory;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.eclipse.imagen.media.codec.ImageCodec;
import org.eclipse.imagen.media.codec.SeekableStream;
import org.eclipse.imagen.media.codec.TIFFDirectory;

public class ImagenImageDirectoryReader {
    private final InputStreamConnectorFactory inputStreamConnectorFactory;

    public ImagenImageDirectoryReader(IResourceReferenceHandler resourceReferenceHandler) {
        this.inputStreamConnectorFactory = new InputStreamConnectorFactory(resourceReferenceHandler);
    }

    public IImageDirectory read(ICanceler canceler, IResourceReference resourceReference) throws CanceledException, IOException {
        ISeekableStreamConnector connector = this.inputStreamConnectorFactory.create(resourceReference);
        try (SeekableStream seekableStream = connector.connect();){
            String[] decoderNames = ImageCodec.getDecoderNames((SeekableStream)seekableStream);
            if (decoderNames != null && decoderNames.length > 0 && (Set.of(decoderNames).contains("jpeg") || Set.of(decoderNames).contains("tiff"))) {
                seekableStream.seek(0L);
                TIFFDirectory directory = new TIFFDirectory(seekableStream, 0);
                IImageDirectory iImageDirectory = new IImageDirectory(){};
                return iImageDirectory;
            }
        }
        return new IImageDirectory(){};
    }

    public boolean isSupported(SeekableStream inputStream) {
        String[] decoderNames = ImageCodec.getDecoderNames((SeekableStream)inputStream);
        if (decoderNames != null && decoderNames.length > 0) {
            if (Set.of(decoderNames).contains("jpeg")) {
                return true;
            }
            if (Set.of(decoderNames).contains("tiff")) {
                return true;
            }
        }
        return false;
    }
}

