/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import java.io.IOException;
import java.net.URISyntaxException;
import net.anwiba.commons.image.imagen.ISeekableStreamConnector;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.UriResourceReference;
import net.anwiba.commons.reference.UrlResourceReference;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.io.url.UrlBuilder;
import net.anwiba.commons.utilities.io.url.parser.UrlParser;
import org.eclipse.imagen.media.codec.ByteArraySeekableStream;
import org.eclipse.imagen.media.codec.FileSeekableStream;
import org.eclipse.imagen.media.codec.MemoryCacheSeekableStream;
import org.eclipse.imagen.media.codec.SeekableStream;

public class InputStreamConnectorFactory {
    private final IResourceReferenceHandler resourceReferenceHandler;

    public InputStreamConnectorFactory(IResourceReferenceHandler resourceReferenceHandler) {
        this.resourceReferenceHandler = resourceReferenceHandler;
    }

    public ISeekableStreamConnector create(IResourceReference reference) {
        return () -> this.connect(reference);
    }

    private SeekableStream connect(final IResourceReference resourceReference) throws IOException {
        try {
            return (SeekableStream)resourceReference.accept((IResourceReferenceVisitor)new IResourceReferenceVisitor<SeekableStream, IOException>(){

                public SeekableStream visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                    return new FileSeekableStream(fileResourceReference.getFile());
                }

                public SeekableStream visitUrlResource(UrlResourceReference urlResourceReference) throws IOException {
                    if (InputStreamConnectorFactory.this.resourceReferenceHandler.isFileSystemResource(resourceReference)) {
                        return InputStreamConnectorFactory.this.openAsFileIfPossible(resourceReference);
                    }
                    return new MemoryCacheSeekableStream(InputStreamConnectorFactory.this.resourceReferenceHandler.openInputStream(resourceReference, value -> value != null && value.startsWith("image")));
                }

                public SeekableStream visitUriResource(UriResourceReference uriResourceReference) throws IOException {
                    if (InputStreamConnectorFactory.this.resourceReferenceHandler.isFileSystemResource(resourceReference)) {
                        return InputStreamConnectorFactory.this.openAsFileIfPossible(resourceReference);
                    }
                    return new MemoryCacheSeekableStream(InputStreamConnectorFactory.this.resourceReferenceHandler.openInputStream(resourceReference, value -> value != null && value.startsWith("image")));
                }

                public SeekableStream visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                    return new ByteArraySeekableStream(memoryResourceReference.getBuffer());
                }

                public SeekableStream visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                    return this.visitFileResource(new FileResourceReference(pathResourceReference.getPath().toFile()));
                }
            });
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed reading the provided resource reference: %s", this.toPrintableString(resourceReference)), e);
        }
    }

    private SeekableStream openAsFileIfPossible(IResourceReference reference) throws IOException {
        try {
            return new FileSeekableStream(this.resourceReferenceHandler.getFile(reference));
        }
        catch (URISyntaxException e) {
            return new MemoryCacheSeekableStream(this.resourceReferenceHandler.openInputStream(reference));
        }
    }

    private String toPrintableString(IResourceReference resourceReference) {
        String string = this.resourceReferenceHandler.toString(resourceReference);
        try {
            IUrl url = new UrlParser().parse(string);
            if (url.getPassword() != null) {
                return new UrlBuilder(url).setPassword("**********").build().toString();
            }
            return new UrlBuilder(url).build().toString();
        }
        catch (CreationException exception) {
            return string;
        }
    }
}

