/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.awt.BufferedImageOperatorFactory;
import net.anwiba.commons.image.imagen.IPlanarImageOperator;
import net.anwiba.commons.image.imagen.ImagenImageContainerUtilities;
import net.anwiba.commons.image.imagen.ImagenImageMetadata;
import net.anwiba.commons.image.imagen.ImagenImageMetadataAdjustor;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageCropOperation;
import net.anwiba.commons.image.operation.ImageInvertOperation;
import net.anwiba.commons.image.operation.ImageMapBandsOperation;
import net.anwiba.commons.image.operation.ImageOpacityOperation;
import net.anwiba.commons.image.operation.ImageScaleOperation;
import net.anwiba.commons.image.operation.ImageToGrayScaleOperation;
import net.anwiba.commons.image.operation.ImageTransparencyColorOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RenderedOp;

class PlanarImageOperatorFactory {
    private IImageMetadataAdjustor metadataAdjustor;

    public PlanarImageOperatorFactory() {
        this(new ImagenImageMetadataAdjustor());
    }

    public PlanarImageOperatorFactory(IImageMetadataAdjustor metadataAdjustor) {
        this.metadataAdjustor = metadataAdjustor;
    }

    public ObjectPair<IPlanarImageOperator, ImagenImageMetadata> create(ImagenImageMetadata metadata, IImageOperation operation, RenderingHints hints) {
        if (operation instanceof ImageScaleOperation) {
            ImageScaleOperation o = (ImageScaleOperation)operation;
            return ObjectPair.of((Object)this.createImageScaleOperation(hints, o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageCropOperation) {
            ImageCropOperation o = (ImageCropOperation)operation;
            return ObjectPair.of((Object)this.createImageCropOperation(hints, o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageMapBandsOperation) {
            ImageMapBandsOperation o = (ImageMapBandsOperation)operation;
            return ObjectPair.of((Object)this.createImageMapBandsOperation(hints, o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageOpacityOperation) {
            ImageOpacityOperation o = (ImageOpacityOperation)operation;
            return ObjectPair.of((Object)this.createImageOpacityOperation(hints, metadata, o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageTransparencyColorOperation) {
            ImageTransparencyColorOperation o = (ImageTransparencyColorOperation)operation;
            return ObjectPair.of((Object)this.createImageTransparencyOperation(hints, o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageInvertOperation) {
            return ObjectPair.of((Object)this.createImageInvertOperation(metadata, hints), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageToGrayScaleOperation) {
            return ObjectPair.of((Object)this.createImageToGrayScaleOperation(hints), (Object)this.adapt(metadata, operation));
        }
        return ObjectPair.of((canceler, source) -> source, (Object)metadata);
    }

    private ImagenImageMetadata adapt(IImageMetadata metadata, IImageOperation operation) {
        return (ImagenImageMetadata)this.metadataAdjustor.adjust(metadata, operation);
    }

    private IPlanarImageOperator createImageScaleOperation(RenderingHints hints, ImageScaleOperation o) {
        return (canceler, source) -> ImagenImageContainerUtilities.scale(hints, (RenderedImage)source, o.getWidthFactor(), o.getHeightFactor(), ImagenImageContainerUtilities.getInterpolation(hints));
    }

    private IPlanarImageOperator createImageCropOperation(RenderingHints hints, ImageCropOperation o) {
        return (canceler, source) -> {
            float height;
            float width;
            float y;
            float x = o.getX();
            RenderedOp cropedRenderOp = ImagenImageContainerUtilities.crop(hints, (RenderedImage)source, x, y = o.getY(), width = o.getWidth(), height = o.getHeight());
            if (cropedRenderOp == null || canceler.isCanceled()) {
                return null;
            }
            return ImagenImageContainerUtilities.translate(hints, (RenderedImage)cropedRenderOp, -x, -y, ImagenImageContainerUtilities.getInterpolation(hints));
        };
    }

    private IPlanarImageOperator createImageMapBandsOperation(RenderingHints hints, ImageMapBandsOperation o) {
        int[] mapping = o.getBandMapping();
        return (canceler, source) -> ImagenImageContainerUtilities.toMapped(hints, source, mapping);
    }

    private IPlanarImageOperator createImageOpacityOperation(RenderingHints hints, IImageMetadata metadata, ImageOpacityOperation o) {
        if (metadata.isIndexed()) {
            return (canceler, source) -> ImagenImageContainerUtilities.toOpacity(hints, (RenderedImage)source, o.getFactor());
        }
        return (canceler, source) -> ImagenImageContainerUtilities.toPlanarImage(BufferedImageOperatorFactory.createImageOpacityOperation(metadata, hints, o).execute(canceler, source.getAsBufferedImage()));
    }

    private IPlanarImageOperator createImageTransparencyOperation(RenderingHints hints, ImageTransparencyColorOperation o) {
        return (canceler, source) -> ImagenImageContainerUtilities.toTransparent(hints, (RenderedImage)source, o.getColor());
    }

    private IPlanarImageOperator createImageInvertOperation(IImageMetadata metadata, RenderingHints hints) {
        if (metadata.isIndexed()) {
            return (canceler, source) -> ImagenImageContainerUtilities.toInverted(hints, (RenderedImage)source);
        }
        return (canceler, source) -> ImagenImageContainerUtilities.toPlanarImage(BufferedImageOperatorFactory.createImageInvertOperation(metadata, hints).execute(canceler, source.getAsBufferedImage()));
    }

    private IPlanarImageOperator createImageToGrayScaleOperation(RenderingHints hints) {
        return (canceler, source) -> ImagenImageContainerUtilities.toGrayScale(hints, (RenderedImage)source);
    }

    IPlanarImageOperator create(ImagenImageMetadata metadata, IObjectList<IImageOperation> imageOperations, RenderingHints hints) {
        if (imageOperations.isEmpty()) {
            return new AggregatedPlanarImageOperator((IObjectList<IPlanarImageOperator>)new ObjectList());
        }
        IOptional<ImageScaleOperation, RuntimeException> scaleOperation = ImageScaleOperation.aggregate(imageOperations);
        IOptional<ImageCropOperation, RuntimeException> cropOperation = ImageCropOperation.aggregate(imageOperations);
        ObjectList operations = new ObjectList();
        if (cropOperation.isAccepted()) {
            operations.add((Object[])new IImageOperation[]{(IImageOperation)cropOperation.get()});
        }
        if (scaleOperation.accept(s -> s.getWidthFactor() < 1.0f && s.getHeightFactor() < 1.0f).isAccepted()) {
            operations.add((Object[])new IImageOperation[]{(IImageOperation)scaleOperation.get()});
        }
        for (IImageOperation operation : imageOperations) {
            if (operation instanceof ImageScaleOperation || operation instanceof ImageCropOperation || operation instanceof ImageMapBandsOperation && ((ImageMapBandsOperation)operation).getMappingSize() == 0) continue;
            operations.add((Object[])new IImageOperation[]{operation});
        }
        if (scaleOperation.accept(s -> s.getWidthFactor() > 1.0f || s.getHeightFactor() > 1.0f).isAccepted()) {
            operations.add((Object[])new IImageOperation[]{(IImageOperation)scaleOperation.get()});
        }
        ObjectList collection = new ObjectList();
        ImagenImageMetadata imageMetadata = metadata;
        for (IImageOperation operation : operations) {
            ObjectPair<IPlanarImageOperator, ImagenImageMetadata> pair = this.create(imageMetadata, operation, hints);
            collection.add((Object[])new IPlanarImageOperator[]{(IPlanarImageOperator)pair.getFirstObject()});
            imageMetadata = (ImagenImageMetadata)pair.getSecondObject();
        }
        return new AggregatedPlanarImageOperator((IObjectList<IPlanarImageOperator>)collection);
    }

    private static final class AggregatedPlanarImageOperator
    implements IPlanarImageOperator {
        private final IObjectList<IPlanarImageOperator> collection;

        public AggregatedPlanarImageOperator(IObjectList<IPlanarImageOperator> collection) {
            this.collection = collection;
        }

        @Override
        public PlanarImage execute(ICanceler canceler, PlanarImage source) throws CanceledException {
            return (PlanarImage)Streams.of(CanceledException.class, this.collection).aggregate((Object)source, (s, o) -> {
                if (canceler.isCanceled()) {
                    return null;
                }
                return s == null ? null : o.execute(canceler, (PlanarImage)s);
            }).get();
        }
    }
}

