/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import net.anwiba.commons.image.AbstractImageContainer;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.imagen.ImagenImageMetadata;
import net.anwiba.commons.image.imagen.PlanarImageOperatorFactory;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RenderedImageAdapter;

public class RenderedImageContainer
extends AbstractImageContainer {
    private final RenderedImage renderedImage;

    public RenderedImageContainer(RenderingHints hints, RenderedImage renderedImage, IImageMetadataAdjustor metadataAdjustor) {
        this(null, renderedImage, (IObjectList<IImageOperation>)new ObjectList(), hints, metadataAdjustor);
    }

    public RenderedImageContainer(IImageMetadata metadata, RenderedImage renderedImage, IObjectList<IImageOperation> operations, RenderingHints hints, IImageMetadataAdjustor metadataAdjustor) {
        super(hints, metadata, operations, metadataAdjustor);
        this.renderedImage = renderedImage;
    }

    @Override
    protected IImageMetadata read(ICanceler canceler, RenderingHints hints) throws CanceledException, IOException {
        ColorModel colorModel = this.renderedImage.getColorModel();
        return new ImagenImageMetadata(this.renderedImage.getWidth(), this.renderedImage.getHeight(), colorModel.getNumColorComponents(), colorModel.getNumComponents(), colorModel.getColorSpace().getType(), colorModel.getTransferType(), colorModel.getTransparency(), colorModel instanceof IndexColorModel);
    }

    @Override
    protected BufferedImage read(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) throws CanceledException, IOException {
        IImageMetadata metadata = this.read(canceler, hints);
        PlanarImage planarImage = new PlanarImageOperatorFactory(metadataAdjustor).create((ImagenImageMetadata)metadata, operations, hints).execute(canceler, (PlanarImage)new RenderedImageAdapter(this.renderedImage));
        return planarImage == null ? null : planarImage.getAsBufferedImage();
    }

    @Override
    protected IImageContainer adapt(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        return new RenderedImageContainer(metadata, this.renderedImage, operations, hints, metadataAdjustor);
    }
}

